package com.vcarecity.dtu.response;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.dtu.constant.Constants;
import com.vcarecity.dtu.service.AbstractConverter;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public class LoginResponse extends AbstractConverter {


    /**
     * 没有消息流水,测量点
     *
     * @param sn
     * @param equipmentNo
     * @return
     */
    @Override
    public byte[] customSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        return new byte[0];
    }

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        //Login not input here
        return new byte[0];
    }

    /**
     * 强制返回当前时间
     *
     * @param sn
     * @param equipmentNo
     * @param list
     * @return
     * @throws NoRequireKeyException
     */
    @Override
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {
        String currentTime = LocalDateTime.now().format(Constants.DATE_TIME_FORMATTER);

        return HexUtil.hexToByteArray(currentTime);
//        return HexUtil.concatAll(HexUtil.intToByteArray(bytes.length, DtuProtocolConfig.DTU_LEN_LEN), bytes);
    }

}
