package com.vcarecity.dtu.service;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.service.sub.IConverter;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public abstract class AbstractConverter implements IConverter {

    @Override
    public byte[] convertMessage(BaseJsonViewBean message) throws NoRequireKeyException {
        Integer sn = message.getSn();
        Integer equipmentNo = message.getEquipmentNo();

        //组装消息流水+测量点
        byte[] body = customSnAndEquipmentNo(sn, equipmentNo);

        List<BaseJsonViewBean.DataItemDTO> dataItems = message.getDataItems();

        //组装DataItem
        byte[] bodyItem = iteratorDataItems(sn, equipmentNo, dataItems);

        //合并
        body = HexUtil.concatAll(body, bodyItem);
        return body;
    }

    /**
     * 组织回复数据帧
     *
     * @param sn
     * @param equipmentNo
     * @param list
     * @return
     * @throws NoRequireKeyException 下发指令时,没有指定的Key
     */
    @NotNull
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {

        byte[] body = new byte[0];
        for (BaseJsonViewBean.DataItemDTO dataItemDTO : list) {
            //转换....
            byte[] bytes = convertItemBody(dataItemDTO.getId(), dataItemDTO.getData());
            if (bytes != null) {
                body = HexUtil.concatAll(body, bytes);
            }
        }
        return body;
    }

    /**
     * 默认组合消息流水,测量点
     *
     * @param sn
     * @param equipmentNo
     * @return
     */
    @Override
    public byte[] defaultSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        //消息流水
        if (sn == null) {
            sn = 0;
        }
        //测量点2
        if (equipmentNo == null) {
            equipmentNo = 0;
        }
        return HexUtil.concatAll(HexUtil.intToByteArray(sn, DtuProtocolConfig.DTU_MSG_FLOW_LEN),
                HexUtil.intToByteArray(equipmentNo, DtuProtocolConfig.DTU_EQUIPMENT_NO_LEN));
    }

    /**
     * 生成 0001(消息流水)+01+(测量点)+0710(功能Id)+00(数据)
     *
     * @param sn
     * @param equipmentNo
     * @param id
     * @param data
     * @return
     * @throws NoRequireKeyException
     */
    @Override
    public byte[] itemBodyConverter(Integer sn, Integer equipmentNo, Integer id, Map<String, Object> data) throws NoRequireKeyException {
        byte[] body = customSnAndEquipmentNo(sn, equipmentNo);
        byte[] temp = HexUtil.intToByteArray(id, DtuProtocolConfig.DTU_INFO_ID_LEN);
        body = HexUtil.concatAll(body, temp);
        return HexUtil.concatAll(body, convertItemBody(id, data));
    }

}
