package com.vcarecity.dtu.upload.login;

import com.vcarecity.allcommon.util.ArrayUtil;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.vcarecity.dtu.constant.CodeConstant.RET_SUCCESS;

/**
 * @author Kerry on 19/01/03
 * <p>
 * <p>
 * 0x06	登录（长时间休眠设备使用）	上行：22
 * 下行：8		上行：
 * String[20] CCID号 +
 * Byte[2] 电池电量，单位%
 * 下行：
 * byte[6]: 时间 +
 * word: 平台缓存的指令数量
 */

public class BatteryLoginParser implements IDtuFrameParser {
    /**
     * 电池百分比
     */
    private static final String BATTERY_PCT = "batteryPct";


    @Override
    public int getCurrentCodeLength() {
        return 20 + 2;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        Map<String, Object> map = new HashMap<>(4);

        byte[] ccid = ArrayUtil.copyTo(data, 0, 20);
        byte[] pct = ArrayUtil.copyTo(data, 20, 2);

        map.put(DtuProtocolJsonConstant.RET, RET_SUCCESS);
        map.put(DtuProtocolJsonConstant.CCID, HexUtil.byteToString(ccid));
        map.put(BATTERY_PCT, HexUtil.byteArrayToInt(pct) + "");
        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, map));
    }
}
