package com.vcarecity.dtu.upload.login;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.vcarecity.dtu.constant.CodeConstant.RET_SUCCESS;

/**
 * @author Kerry on 18/06/27
 */

public class LoginParser implements IDtuFrameParser {

    @Override
    public int getCurrentCodeLength() {
        return 20;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        Map<String, Object> map = new HashMap<>(2);
        map.put(DtuProtocolJsonConstant.RET, RET_SUCCESS);
        map.put(DtuProtocolJsonConstant.CCID, HexUtil.byteToString(data));
        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, map));
    }
}
