package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/12
 * <p>
 * 7e7e7e0000000000019000350101000201434d4e45540000000000000000000000692e6465766963652e79756e2e7663617265636974792e636f6d000000003c508c
 */

public class ReadData513 implements IDtuFrameParser {

    private static final String APN = "apn";
    private static final String IP = "ip";
    private static final String PORT = "port";

    @Override
    public int getCurrentCodeLength() {
        return 16 + 30 + 2;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        int pos = 0;
        byte[] apnByte = Arrays.copyOfRange(data, pos, pos + 16);
        pos += apnByte.length;
        byte[] ipByte = Arrays.copyOfRange(data, pos, pos + 30);
        pos += ipByte.length;

        byte[] portByte = Arrays.copyOfRange(data, pos, pos + 2);

        HashMap<String, Object> hashMap = new HashMap<>(4);

        hashMap.put(APN, new String(apnByte).trim());
        hashMap.put(IP, new String(ipByte).trim());
        hashMap.put(PORT, String.valueOf(HexUtil.byteArrayToInt(portByte)));

        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));

        return parserOneDataItem(dataType, hashMap);
    }
}
