package com.vcarecity.dtu.upload.read;

import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/12
 * <p>
 * 7e7e7e4442832e833d90003d01010102f87a4330303030303030303a4442832e833d3aaa2832e833c4442832e833c4442832ea3a32383933323834393730363931393934303735353230
 */
public class ReadData760 implements IDtuFrameParser {
    private static final String EQUIPMENT_TYPE = "equipmentType";
    private static final String EQUIPMENT_ADDRESS = "equipmentAddress";
    private static final String IMEI_NO = "imeiNo";
    private static final String CCID = "ccid";


    @Override
    public int getCurrentCodeLength() {
        return 10 + 1 + 6 + 1 + 15 + 1 + 20 + 1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        int pos = 0;

        byte[] equipmentTypeByte = Arrays.copyOfRange(data, pos, pos + 10);
        pos += equipmentTypeByte.length + 1;

        byte[] equipmentAddressByte = Arrays.copyOfRange(data, pos, pos + 6);
        pos += equipmentAddressByte.length + 1;

        byte[] imeiNoByte = Arrays.copyOfRange(data, pos, pos + 15);
        pos += imeiNoByte.length + 1;

        byte[] ccidByte = Arrays.copyOfRange(data, pos, pos + 20);

        //init size 8
        HashMap<String, Object> hashMap = new HashMap<>(2 << 2);

        hashMap.put(EQUIPMENT_TYPE, new String(equipmentTypeByte).trim());
        hashMap.put(EQUIPMENT_ADDRESS, HexUtil.byteArrayToHex(equipmentAddressByte));
        hashMap.put(IMEI_NO, new String(imeiNoByte).trim());
        hashMap.put(CCID, new String(ccidByte).trim());

        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));


        return this.parserOneDataItem(dataType, hashMap);
    }
}