package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/06/27
 * <p>
 * 7e7e7e4442832e833c900009010101030900aa00022e
 */

public class ReadData777 implements IDtuFrameParser {

    private static final String ALARM_UPPER_LIMIT = "alarmUpperLimit";
    private static final String ALARM_LOWER_LIMIT = "alarmLowerLimit";


    @Override
    public int getCurrentCodeLength() {
        return 2 + 2;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;

        byte[] upperByte = Arrays.copyOf(data, 2);
        pos += upperByte.length;

        byte[] lowerByte = Arrays.copyOfRange(data, pos, pos + 2);

        HashMap<String, Object> hashMap = new HashMap<>(4);
        hashMap.put(ALARM_UPPER_LIMIT, String.valueOf(HexUtil.byteArrayToInt(upperByte)));
        hashMap.put(ALARM_LOWER_LIMIT, String.valueOf(HexUtil.byteArrayToInt(lowerByte)));
        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));
        return this.parserOneDataItem(dataType, hashMap);
    }
}
