package com.vcarecity.dtu.upload.report;






import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 */

public class ReportData1537 implements IDtuFrameParser {
    private static final String HOST_MODEL = "hostModel";
    private static final String DEVICE_ID = "deviceId";
    private static final String EVENT_TYPE = "eventType";
    private static final String ACQUISITION_TIME = "acquisitionTime";
    private static final String CNT = "cnt";
    private static final String DESC = "desc";


    @Override
    public int getCurrentCodeLength() {
        return 1 + 3 + 1 + 1 + 6 + 1 + 1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        byte[] hostModelByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += hostModelByte.length;

        byte[] deviceIdByte = Arrays.copyOfRange(data, pos, pos + 3);
        pos += deviceIdByte.length;

        byte[] eventTypeByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += eventTypeByte.length;

        byte[] eventByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += eventByte.length;


        byte[] acquisitionTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
        pos += acquisitionTimeByte.length;

        byte[] cntByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += cntByte.length;

        byte[] descByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += descByte.length;


        HashMap<String, Object> hashMap = new HashMap<>(8);

        hashMap.put(HOST_MODEL, String.valueOf(HexUtil.byteArrayToInt(hostModelByte)));
        hashMap.put(DEVICE_ID, HexUtil.byteArrayToHex(deviceIdByte));
        hashMap.put(EVENT_TYPE, String.valueOf(HexUtil.byteArrayToInt(eventTypeByte)));
        hashMap.put(DtuProtocolJsonConstant.EVENT, String.valueOf(HexUtil.byteArrayToInt(eventByte)));
        hashMap.put(ACQUISITION_TIME, HexUtil.byteArrayToHex(acquisitionTimeByte));
        hashMap.put(CNT, String.valueOf(HexUtil.byteArrayToInt(cntByte)));
        hashMap.put(DESC, String.valueOf(HexUtil.byteArrayToInt(descByte)));

        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, hashMap));
    }
}
