package com.vcarecity.dtu.upload.report;


import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 */

public class ReportData1538 implements IDtuFrameParser {
    private static final String HOST_MODEL = "hostModel";
    private static final String ROW_COUNT = "rowCount";
    private static final String DATA_CONTENT = "dataContent";

    @Override
    public int getCurrentCodeLength() {
        // 1 + 1 + (-1)
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        byte[] hostModelByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += hostModelByte.length;
        byte[] rowCountByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += rowCountByte.length;
        byte[] dataContentByte = Arrays.copyOfRange(data, pos, data.length);

        HashMap<String, Object> hashMap = new HashMap<>(2);

        hashMap.put(HOST_MODEL, String.valueOf(HexUtil.byteArrayToInt(hostModelByte)));
        hashMap.put(ROW_COUNT, String.valueOf(HexUtil.byteArrayToInt(rowCountByte)));
        hashMap.put(DATA_CONTENT, HexUtil.byteArrayToHex(dataContentByte));

        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, hashMap));
    }
}
