package com.vcarecity.dtu.upload.report;


import com.vcarecity.allcommon.util.HexUtil;;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 * <p>
 * 反射用到
 */

public class ReportData1793 implements IDtuFrameParser {

    private static final String INDICATION = "indication";
    private static final String CNT = "cnt";
    private static final String DESC = "desc";

    @Override
    public int getCurrentCodeLength() {
        //6 + 2 + 1 + 1 + (-1)
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;

        byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
        pos += dateTimeByte.length;

        byte[] indicationByte = Arrays.copyOfRange(data, pos, pos + 2);
        pos += indicationByte.length;

        byte[] eventByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += eventByte.length;

        byte[] cntByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += cntByte.length;

        byte[] descByte = Arrays.copyOfRange(data, pos, data.length);
        pos += descByte.length;

        HashMap<String, Object> oneMap = new HashMap<>(8);

        oneMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));
        oneMap.put(INDICATION, String.valueOf(HexUtil.byteArrayToInt(indicationByte)));
        oneMap.put(DtuProtocolJsonConstant.EVENT, String.valueOf(HexUtil.byteArrayToInt(eventByte)));
        oneMap.put(CNT, String.valueOf(HexUtil.byteArrayToInt(cntByte)));
        oneMap.put(DESC, HexUtil.byteArrayToHex(descByte));


        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, oneMap));
    }
}
