package com.vcarecity.dtu.upload.report;





import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 * <p>
 * 反射用到
 */

public class ReportData1808 implements IDtuFrameParser {

    private static final String LINE_NO = "lineNo";
    private static final String ALARM_STATUS = "alarmStatus";
    private static final String ALARM_DATA = "alarmData";

    @Override
    public int getCurrentCodeLength() {
        //1 + 1 + 6 + 1 + 2
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        int dataCnt = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, pos, 1));
        pos += 1;

        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>();
        for (int i = 0; i < dataCnt; i++) {
            byte[] lineNoByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += lineNoByte.length;
            byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
            pos += dateTimeByte.length;
            byte[] alarmStatusByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += alarmStatusByte.length;
            byte[] alarmDataByte = Arrays.copyOfRange(data, pos, pos + 2);
            pos += alarmDataByte.length;

            HashMap<String, Object> oneMap = new HashMap<>(4);

            oneMap.put(LINE_NO, String.valueOf(HexUtil.byteArrayToInt(lineNoByte)));
            oneMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));
            oneMap.put(ALARM_STATUS, String.valueOf(HexUtil.byteArrayToInt(alarmStatusByte)));
            oneMap.put(ALARM_DATA, String.valueOf(HexUtil.byteArrayToInt(alarmDataByte)));

            list.add(new BaseJsonViewBean.DataItemDTO(dataType, oneMap));
        }
        return list;
    }
}
