package com.vcarecity.dtu.upload.report;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 * <p>
 * 7e7e7e000000000001b0000e00010102d00118041118181801126a
 * <p>
 * 7e7e7e000000000001b0001600010102d0021804111818180112180411181819112256
 */

public class ReportData720 implements IDtuFrameParser {

    private static final String PORT_NO = "portNo";


    @Override
    public int getCurrentCodeLength() {
        //1+6+1+1
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        int dataCnt = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, pos, 1));
        pos += 1;
        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>();
        for (int i = 0; i < dataCnt; i++) {
            byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
            pos += dateTimeByte.length;

            byte[] portNoByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += portNoByte.length;

            byte[] eventByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += eventByte.length;

            HashMap<String, Object> oneMap = new HashMap<>(4);

            oneMap.put(PORT_NO, String.valueOf(HexUtil.byteArrayToInt(portNoByte)));
            oneMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));
            oneMap.put(DtuProtocolJsonConstant.EVENT, String.valueOf(HexUtil.byteArrayToInt(eventByte)));

            list.add(new BaseJsonViewBean.DataItemDTO(dataType, oneMap));
        }
        return list;
    }
}
