package com.vcarecity.dtu.upload.report;




import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 */

public class ReportData722 implements IDtuFrameParser {

    private static final String PORT_NO = "portNo";
    private static final String STATE = "state";
    private static final String POWER = "power";


    @Override
    public int getCurrentCodeLength() {
        //1+4+6+1+2
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        int dataCnt = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, pos, 1));
        pos += 1;
        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>();
        for (int i = 0; i < dataCnt; i++) {
            byte[] portNoByte = Arrays.copyOfRange(data, pos, pos + 4);
            pos += portNoByte.length;
            byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
            pos += dateTimeByte.length;
            byte[] eventByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += eventByte.length;

            byte[] stateByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += stateByte.length;

            byte[] powerByte = Arrays.copyOfRange(data, pos, pos + 2);
            pos += powerByte.length;

            HashMap<String, Object> oneMap = new HashMap<>(8);

            oneMap.put(PORT_NO, HexUtil.byteArrayToHex(portNoByte));
            oneMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));
            oneMap.put(DtuProtocolJsonConstant.EVENT, String.valueOf(HexUtil.byteArrayToInt(eventByte)));
            oneMap.put(STATE, String.valueOf(HexUtil.byteArrayToInt(stateByte)));
            oneMap.put(POWER, String.valueOf(HexUtil.byteArrayToInt(powerByte)));

            list.add(new BaseJsonViewBean.DataItemDTO(dataType, oneMap));
        }
        return list;
    }
}
