/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.dtu.service.impl;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.service.IConvertJsonService;
import com.vcarecity.common.service.sub.IConverter;
import com.vcarecity.common.util.CrcUtil;
import com.vcarecity.dtu.issued.read.IssuedRead;
import com.vcarecity.dtu.issued.read.IssuedReadCommon;
import com.vcarecity.dtu.issued.write.IssuedWrite;
import com.vcarecity.dtu.response.BatteryLoginResponse;
import com.vcarecity.dtu.response.HeartBeatResponse;
import com.vcarecity.dtu.response.LoginResponse;
import com.vcarecity.dtu.response.ReportResponse;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertJsonServiceImpl
implements IConvertJsonService<BaseJsonViewBean> {
    private static Logger logger = LoggerFactory.getLogger(ConvertJsonServiceImpl.class);
    protected static ConcurrentHashMap<String, IConverter> CONVERTER_CACHE = new ConcurrentHashMap(64);
    private static final String PATH_ISSUED_READ = IssuedRead.class.getName();
    private static final String PATH_ISSUED_WRITE = IssuedWrite.class.getName();

    public byte[] convertJson(BaseJsonViewBean messageContext) throws NoRequireKeyException {
        if (messageContext == null) {
            return null;
        }
        int funCode = messageContext.getFunctionWord();
        byte[] body = new byte[]{};
        switch (messageContext.getFunctionWord()) {
            case 132: {
                funCode -= 128;
                messageContext.setSn(null);
                messageContext.setEquipmentNo(null);
                HeartBeatResponse converter = new HeartBeatResponse();
                body = converter.convert(messageContext);
                break;
            }
            case 130: {
                funCode -= 128;
                messageContext.setSn(null);
                messageContext.setEquipmentNo(null);
                LoginResponse converter = new LoginResponse();
                body = converter.convert(messageContext);
                break;
            }
            case 134: {
                funCode -= 128;
                messageContext.setEquipmentNo(null);
                BatteryLoginResponse converter = new BatteryLoginResponse();
                body = converter.convert(messageContext);
                messageContext.setSn(null);
                break;
            }
            case 176: {
                funCode -= 128;
                IConverter converter = this.getReportResponse(messageContext);
                body = converter.convert(messageContext);
                break;
            }
            case 16: {
                List dataItems = messageContext.getDataItems();
                byte[] eqAndSnRead = null;
                for (BaseJsonViewBean.DataItemDTO dataItem : dataItems) {
                    IConverter converter = this.getIssuedReadConverter(dataItem.getId());
                    if (eqAndSnRead == null && (eqAndSnRead = converter.customSnAndEquipmentNo(messageContext.getSn(), messageContext.getEquipmentNo())) != null) {
                        body = HexUtil.concatAll((byte[][])new byte[][]{eqAndSnRead, body});
                    }
                    if (dataItem.getId() == null) continue;
                    byte[] idArrayRead = HexUtil.intToByteArray((Object)dataItem.getId(), (int)2);
                    body = HexUtil.concatAll((byte[][])new byte[][]{body, idArrayRead});
                    byte[] onceArrayData = converter.convertItemBody(dataItem.getId(), dataItem.getData());
                    if (onceArrayData == null) continue;
                    body = HexUtil.concatAll((byte[][])new byte[][]{body, onceArrayData});
                }
                break;
            }
            case 32: {
                List dataItemsWrite = messageContext.getDataItems();
                byte[] eqAndSnWrite = null;
                for (BaseJsonViewBean.DataItemDTO dataItem : dataItemsWrite) {
                    IConverter converter = this.getIssuedWriteConverter(dataItem.getId());
                    if (converter == null) continue;
                    if (eqAndSnWrite == null && (eqAndSnWrite = converter.customSnAndEquipmentNo(messageContext.getSn(), messageContext.getEquipmentNo())) != null) {
                        body = HexUtil.concatAll((byte[][])new byte[][]{eqAndSnWrite, body});
                    }
                    if (dataItem.getId() == null) continue;
                    byte[] idArrayWrite = HexUtil.intToByteArray((Object)dataItem.getId(), (int)2);
                    body = HexUtil.concatAll((byte[][])new byte[][]{body, idArrayWrite});
                    byte[] onceArrayData = converter.convertItemBody(dataItem.getId(), dataItem.getData());
                    if (onceArrayData == null) continue;
                    body = HexUtil.concatAll((byte[][])new byte[][]{body, onceArrayData});
                }
                break;
            }
            default: {
                return null;
            }
        }
        messageContext.setFunctionWord(Integer.valueOf(funCode));
        byte[] msgBody = HexUtil.concatAll((byte[][])new byte[][]{HexUtil.hexToByteArray((String)messageContext.getUnitNo(), (int)6), HexUtil.intToByteArray((Object)messageContext.getFunctionWord(), (int)1), HexUtil.intToByteArray((int)body.length, (int)2), body});
        int crcCode = CrcUtil.validate((byte[])msgBody);
        return HexUtil.concatAll((byte[][])new byte[][]{DtuProtocolConfig.DTU_MASK, msgBody, HexUtil.intToByteArray((int)crcCode, (int)1)});
    }

    private IConverter getIssuedReadConverter(Integer id) {
        try {
            return this.newConverterInstance(PATH_ISSUED_READ + String.valueOf(id));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.warn("can not getIssuedReadConverter class on id = {}", (Object)id);
            return new IssuedReadCommon();
        }
    }

    private IConverter getIssuedWriteConverter(Integer id) {
        try {
            return this.newConverterInstance(PATH_ISSUED_WRITE + String.valueOf(id));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.warn("can not getIssuedWriteConverter class on id = {}", (Object)id);
            return null;
        }
    }

    private IConverter getReportResponse(BaseJsonViewBean messageContext) {
        return new ReportResponse();
    }

    private IConverter newConverterInstance(String packageName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        IConverter converter = CONVERTER_CACHE.get(packageName);
        if (converter != null) {
            return converter;
        }
        Class<?> forName = Class.forName(packageName);
        converter = (IConverter)forName.newInstance();
        CONVERTER_CACHE.put(packageName, converter);
        return converter;
    }

    public static void setConverterCache(ConcurrentHashMap<String, IConverter> converterCache) {
        CONVERTER_CACHE = converterCache;
    }
}

