/*
 * Decompiled with CFR 0.152.
 */
package me.yuxiaoyao.config.loader;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigLoader {
    private static final String PROFILE = "profile";
    private static final String ACTIVE = "active";
    public static final String ACTIVE_PROFILE = "profile.active";
    public static String DEFAULT_FILE_CONFIG_FOLDER = "config";
    private static String DEFAULT_APPLICATION = "application";
    private static String START_PLACEHOLDER = "${";
    private static String END_PLACEHOLDER = "}";

    private static InputStream getConfigFileAsStream(String path) {
        try {
            File file = new File(DEFAULT_FILE_CONFIG_FOLDER + File.separator + path);
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static <T> T parseConfig(Class<T> clazz) {
        return ConfigLoader.parseConfig(null, clazz, null);
    }

    public static <T> T parseConfig(String[] args, Class<T> clazz, ConfigListener configListener) {
        Map map = ConfigLoader.loaderConfig(args, configListener);
        return (T)ConfigLoader.getObjectMapper().convertValue((Object)map, clazz);
    }

    public static <T> T parseConfig(TypeReference<T> toValueTypeRef) {
        return ConfigLoader.parseConfig(null, toValueTypeRef, null);
    }

    public static <T> T parseConfig(String[] args, TypeReference<T> toValueTypeRef, ConfigListener configListener) {
        Map map = ConfigLoader.loaderConfig(args, configListener);
        return (T)ConfigLoader.getObjectMapper().convertValue((Object)map, toValueTypeRef);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static Map loaderConfig() {
        return ConfigLoader.loaderConfig(null, null);
    }

    public static Map loaderConfig(String[] args, ConfigListener configListener) {
        Map profileMap;
        Map defaultProperties = ConfigLoader.selectConfigPosition(DEFAULT_APPLICATION);
        if (defaultProperties == null) {
            return null;
        }
        String profile = ConfigLoader.getProfileByArgs(args);
        if (profile == null || profile.length() == 0) {
            profile = ConfigLoader.getActiveProfile(defaultProperties);
        }
        if (configListener != null) {
            configListener.activeProfile(profile);
        }
        if ((profileMap = ConfigLoader.selectConfigPosition(DEFAULT_APPLICATION + "-" + profile)) != null) {
            ConfigLoader.removeActiveProfile(profileMap);
            defaultProperties.putAll(profileMap);
        }
        return ConfigLoader.propertiesHandler(defaultProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map selectConfigPosition(String baseFilename) {
        InputStream configFileAsStream = null;
        MapperFactoryEnum parseType = null;
        for (MapperFactoryEnum value : MapperFactoryEnum.values()) {
            if (value.getFactory() == null || (configFileAsStream = ConfigLoader.getConfigFileAsStream(baseFilename + "." + value.getName())) == null) continue;
            parseType = value;
            break;
        }
        if (parseType == null) {
            return null;
        }
        ObjectMapper objectMapper = parseType.getObjectMapper();
        if (objectMapper == null) {
            return null;
        }
        try {
            Map map = (Map)objectMapper.readValue(configFileAsStream, LinkedHashMap.class);
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                configFileAsStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getActiveProfile(Map fileMap) {
        Object o;
        Object profile = fileMap.get(PROFILE);
        if (profile instanceof Map && (o = ((Map)profile).get(ACTIVE)) != null) {
            return (String)o;
        }
        return null;
    }

    private static void removeActiveProfile(Map map) {
        Object profile = map.get(PROFILE);
        if (profile instanceof Map) {
            ((Map)profile).remove(ACTIVE);
        }
    }

    private static Map propertiesHandler(Map map) {
        LinkedHashMap<Object, String> preHandler = new LinkedHashMap<Object, String>();
        ConfigLoader.findPreResolveProperties(map, preHandler, null);
        Map<Object, Object> objectObjectMap = ConfigLoader.resolveProperties(map, preHandler);
        ConfigLoader.replaceProperties(map, objectObjectMap);
        return map;
    }

    private static Object getProperties(Map map, String key) {
        int i = key.indexOf(".");
        if (i == -1) {
            return map.get(key);
        }
        String currentKey = key.substring(0, i);
        Object o = map.get(currentKey);
        if (o instanceof Map) {
            return ConfigLoader.getProperties((Map)o, key.substring(i + 1));
        }
        return o;
    }

    private static void setProperties(Map map, String key, Object value) {
        if (map == null) {
            return;
        }
        int i = key.indexOf(".");
        if (i == -1) {
            map.put(key, value);
            return;
        }
        String currentKey = key.substring(0, i);
        Object o = map.get(currentKey);
        if (o instanceof Map) {
            ConfigLoader.setProperties((Map)o, key.substring(i + 1), value);
        } else {
            map.put(key, value);
        }
    }

    public static void replaceProperties(Map map, Map<Object, ?> handlerMap) {
        for (Object o : handlerMap.keySet()) {
            Object value = handlerMap.get(o);
            ConfigLoader.setProperties(map, o.toString(), value);
        }
    }

    public static Map<Object, Object> resolveProperties(Map map, Map<Object, ?> preHandlerMap) {
        LinkedHashMap<Object, Object> processedMap = new LinkedHashMap<Object, Object>(preHandlerMap.size());
        for (Object o : preHandlerMap.keySet()) {
            Object value = preHandlerMap.get(o);
            if (!(value instanceof String)) continue;
            String str = ((String)value).trim();
            String[] defaultValue = (str = str.substring(START_PLACEHOLDER.length(), str.length() - END_PLACEHOLDER.length())).split(":");
            Object properties = defaultValue.length > 1 ? ConfigLoader.getProperties(map, defaultValue[0]) : ConfigLoader.getProperties(map, defaultValue[0]);
            if (properties == null) {
                properties = defaultValue.length > 1 ? defaultValue[1] : value;
            }
            processedMap.put(o, properties);
        }
        return processedMap;
    }

    public static void findPreResolveProperties(Map map, Map<Object, String> result, String prefix) {
        for (Object key : map.keySet()) {
            String str;
            Object value = map.get(key);
            if (value instanceof Map) {
                ConfigLoader.findPreResolveProperties((Map)value, result, prefix == null ? key.toString() : prefix + "." + key.toString());
                continue;
            }
            if (!(value instanceof String) || !(str = ((String)value).trim()).startsWith(START_PLACEHOLDER) || !str.endsWith(END_PLACEHOLDER)) continue;
            if (prefix == null) {
                result.put(key.toString(), str);
                continue;
            }
            result.put(prefix + "." + key.toString(), str);
        }
    }

    private static String getProfileByArgs(String[] args) {
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (!(arg = arg.trim()).startsWith("--profile.active=")) continue;
                return arg.substring("--profile.active=".length());
            }
        }
        return null;
    }

    public static interface ConfigListener {
        public void activeProfile(String var1);
    }

    private static enum MapperFactoryEnum {
        YML("yml", "com.fasterxml.jackson.dataformat.yaml.YAMLFactory"),
        YAML("yaml", "com.fasterxml.jackson.dataformat.yaml.YAMLFactory"),
        PROPERTIES("properties", "com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper"),
        JSON("json", ObjectMapper.class.getCanonicalName());

        private String name;
        private Class<?> factory;

        private MapperFactoryEnum(String name, String className) {
            this.name = name;
            this.factory = MapperFactoryEnum.findClass(className);
        }

        private static Class<?> findClass(String classname) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getFactory() {
            return this.factory;
        }

        public ObjectMapper getObjectMapper() {
            if (this.factory == null) {
                return null;
            }
            try {
                Object o = this.factory.newInstance();
                ObjectMapper objectMapper = this == YML || this == YAML ? new ObjectMapper((JsonFactory)o) : (ObjectMapper)o;
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                return objectMapper;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

