/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.client;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.exception.ClientException;
import org.seg.lib.net.client.handler.BaseClientHandler;
import org.seg.lib.net.client.handler.ClientHandler;
import org.seg.lib.net.encoder.SegPackageEncoder;
import org.seg.lib.util.SegPackageUtil;
import org.seg.lib.util.Util;

public abstract class ClientImpl
implements Client {
    protected int appId;
    protected boolean defaultIsCompressed = false;
    protected boolean defaultIsEncryption = false;
    protected boolean defaultIsCRC = false;
    protected SegPackageEncoder encoder = new SegPackageEncoder();
    protected ClientHandler handler = new BaseClientHandler();
    private RSAPublicKey RSAPublicKey;
    private PrivateKey RSAPrivateKey;
    protected SecretKey DESKey;
    protected long sendHearBeatInterval = 60000L;

    @Override
    public int getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(int appId) {
        this.appId = appId;
    }

    @Override
    public void setDefaultIsCompressed(boolean defaultIsCompressed) {
        this.defaultIsCompressed = defaultIsCompressed;
    }

    @Override
    public boolean isDefaultIsCompressed() {
        return this.defaultIsCompressed;
    }

    @Override
    public void setDefaultIsEncryption(boolean defaultIsEncryption) {
        this.defaultIsEncryption = defaultIsEncryption;
    }

    @Override
    public boolean isDefaultIsEncryption() {
        return this.defaultIsEncryption;
    }

    @Override
    public void setDefaultIsCRC(boolean defaultIsCRC) {
        this.defaultIsCRC = defaultIsCRC;
    }

    @Override
    public boolean isDefaultIsCRC() {
        return this.defaultIsCRC;
    }

    @Override
    public void login(LoginBuff.Login login) {
        try {
            byte[] bodyData = login.toByteArray();
            byte[] data = this.encoder.encode(false, false, false, this.getAppId(), (short)1, SegPackageUtil.getSerialNumber(), bodyData, this.getDESKey());
            this.send(data);
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void sendHearBeat() {
        try {
            byte[] body = new byte[]{};
            byte[] data = this.encoder.encode(false, false, false, this.getAppId(), (short)3, SegPackageUtil.getSerialNumber(), body, this.getDESKey());
            this.send(data);
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void sendPackage(short messageId, byte[] bodyData) {
        this.sendPackage(messageId, SegPackageUtil.getSerialNumber(), bodyData, this.isDefaultIsCompressed(), this.isDefaultIsEncryption(), this.isDefaultIsCRC());
    }

    @Override
    public void sendPackage(short messageId, int serialNumber, byte[] bodyData) {
        this.sendPackage(messageId, serialNumber, bodyData, this.isDefaultIsCompressed(), this.isDefaultIsEncryption(), this.isDefaultIsCRC());
    }

    @Override
    public void sendPackage(short messageId, byte[] bodyData, boolean isCompressed, boolean isEncryption, boolean isCRC) {
        this.sendPackage(messageId, SegPackageUtil.getSerialNumber(), bodyData, isCompressed, isEncryption, isCRC);
    }

    @Override
    public void sendPackage(short messageId, int serialNumber, byte[] bodyData, boolean isCompressed, boolean isEncryption, boolean isCRC) {
        if (isEncryption && this.getDESKey() == null) {
            ClientException e = new ClientException("no DES-Key");
            this.getHandler().exceptionCaught(e);
        }
        try {
            byte[] data = this.encoder.encode(isCompressed, isEncryption, isCRC, this.appId, messageId, serialNumber, bodyData, this.DESKey);
            this.send(data);
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void setHandler(ClientHandler handler) {
        this.handler = handler;
    }

    @Override
    public ClientHandler getHandler() {
        return this.handler;
    }

    @Override
    public void initRSA() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(512);
        KeyPair kp = kpg.generateKeyPair();
        this.RSAPublicKey = (RSAPublicKey)kp.getPublic();
        this.RSAPrivateKey = kp.getPrivate();
    }

    @Override
    public PrivateKey getRSAPrivateKey() {
        return this.RSAPrivateKey;
    }

    @Override
    public byte[] getRSAModuleBytes() throws ClientException {
        if (this.RSAPublicKey == null || this.RSAPrivateKey == null) {
            throw new ClientException("please initRSA first!");
        }
        return Util.clearForeZero(this.RSAPublicKey.getModulus().toByteArray());
    }

    @Override
    public byte[] getRSAPublicExponentBytes() throws ClientException {
        if (this.RSAPublicKey == null || this.RSAPrivateKey == null) {
            throw new ClientException("please initRSA first!");
        }
        return Util.clearForeZero(this.RSAPublicKey.getPublicExponent().toByteArray());
    }

    @Override
    public SecretKey getDESKey() {
        return this.DESKey;
    }

    @Override
    public void initDES(byte[] keyBytes) throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec desKeySpec = new DESKeySpec(keyBytes);
        this.DESKey = keyFactory.generateSecret(desKeySpec);
    }

    @Override
    public long getSendHearBeatInterval() {
        return this.sendHearBeatInterval;
    }

    @Override
    public void setSendHearBeatInterval(long sendHearBeatInterval) {
        this.sendHearBeatInterval = sendHearBeatInterval;
    }
}

