/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.client.handler;

import java.io.IOException;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.handler.ClientHandler;
import org.seg.lib.net.client.manager.ClientManager;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.util.Util;

public class BaseClientHandler
implements ClientHandler {
    @Override
    public void handlePackage(Client client, SegPackage pkg) throws Exception {
        if (pkg.getHead().getMessageId() == -32767) {
            this.handleLoginAck(client, pkg);
        } else {
            this.handleOthers(client, pkg);
        }
    }

    protected void handleOthers(Client client, SegPackage pkg) throws Exception {
        System.out.println("[BaseClientHandler]client receive message:" + pkg.getHead().getMessageId());
    }

    @Override
    public void exceptionCaught(Throwable e) {
        e.printStackTrace();
    }

    protected void handleLoginAck(Client client, SegPackage pkg) throws Exception {
        byte[] realBody = pkg.getRealBody();
        LoginAckBuff.LoginAck loginAck = LoginAckBuff.LoginAck.parseFrom(realBody);
        if (loginAck.getResult() == 0) {
            if (loginAck.hasDesKey()) {
                byte[] rdesKeyBytes = loginAck.getDesKey().toByteArray();
                byte[] decodeDesKeyByte = Util.decodeRSA(client.getRSAPrivateKey(), rdesKeyBytes, 0, 64);
                if (decodeDesKeyByte.length != 8) {
                    throw new IOException("return des key is wrong,decrypted key bytes is:" + Util.getBytesString(decodeDesKeyByte));
                }
                client.initDES(decodeDesKeyByte);
            }
            ClientManager.addClient(client);
        }
    }

    @Override
    public void clientConnected() {
        System.out.println("clientConnected");
    }

    @Override
    public void clientDisConnected() {
        System.out.println("clientDisConnected");
    }
}

