/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.client.tcp;

import java.nio.ByteBuffer;
import org.seg.lib.net.client.tcp.TCPClient;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.stream.BaseStreamAnalysor;
import org.seg.lib.stream.PackageHandler;
import org.seg.lib.stream.PackageMaker;
import org.seg.lib.stream.StreamAnalysor;

public class SegPackageMaker
implements PackageMaker,
PackageHandler {
    private StreamAnalysor analysor = new BaseStreamAnalysor(this);
    private TCPClient client;

    public SegPackageMaker(TCPClient client) {
        this.client = client;
    }

    @Override
    public void dealData(ByteBuffer buff, int len) throws Exception {
        this.analysor.handleStream(buff, len);
    }

    @Override
    public void packageReceived(byte[] pkg) {
        try {
            SegPackage segpkg = SegPackage.parse(pkg, this.client.getDESKey());
            this.client.getHandler().handlePackage(this.client, segpkg);
        }
        catch (Throwable e) {
            this.client.getHandler().exceptionCaught(e);
        }
    }
}

