/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.client.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.client.ClientImpl;
import org.seg.lib.net.client.manager.ClientManager;
import org.seg.lib.net.client.tcp.SegPackageMaker;
import org.seg.lib.net.client.tcp.TCPClient;
import org.seg.lib.stream.PackageMaker;
import org.seg.lib.util.IOUtil;
import org.seg.lib.util.SegPackageUtil;

public class TCPClientImpl
extends ClientImpl
implements TCPClient {
    private ReceiveDataThread receiveDataThread;
    private boolean usePackageMaker = true;
    private PackageMaker packageMaker = new SegPackageMaker(this);
    private String serverIP;
    private int serverPort;
    private Socket socket;
    private DataInputStream is;
    private OutputStream os;
    private long lastConnectTime;
    private long MIN_RECONNECT_INTERVAL = 10000L;
    private long SERVER_LAST_COMMUNICATE_TIME = System.currentTimeMillis();
    private byte[] lastLoginBodyBytes;
    private boolean receiveDataThreadIsRunning = false;

    public boolean isUsePackageMaker() {
        return this.usePackageMaker;
    }

    public void setUsePackageMaker(boolean usePackageMaker) {
        this.usePackageMaker = usePackageMaker;
    }

    public TCPClientImpl(String serverIP, int serverPort) {
        this.serverIP = serverIP;
        this.serverPort = serverPort;
    }

    @Override
    public void disconnect() {
        IOUtil.closeIS(this.is);
        IOUtil.closeOS(this.os);
        IOUtil.closeSocket(this.socket);
    }

    private boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    @Override
    public boolean connect() {
        if (this.isConnected()) {
            this.disconnect();
        }
        try {
            this.lastConnectTime = System.currentTimeMillis();
            this.doConnect();
            if (!this.receiveDataThreadIsRunning) {
                this.receiveDataThreadIsRunning = true;
                this.receiveDataThread = new ReceiveDataThread();
                this.receiveDataThread.setDaemon(true);
                this.receiveDataThread.start();
            } else {
                System.err.println("receiveDataThread isRunning...");
            }
            try {
                this.getHandler().clientConnected();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
            this.disconnect();
            return false;
        }
    }

    private void doConnect() throws IOException {
        this.socket = new Socket(this.serverIP, this.serverPort);
        this.is = new DataInputStream(this.socket.getInputStream());
        this.os = this.socket.getOutputStream();
    }

    @Override
    public void timerTaskStart() {
        try {
            long now = System.currentTimeMillis();
            if (!this.isConnected()) {
                if (now - this.lastConnectTime >= this.MIN_RECONNECT_INTERVAL && this.connect()) {
                    this.login(this.lastLoginBodyBytes);
                }
            } else if (now - this.SERVER_LAST_COMMUNICATE_TIME >= this.sendHearBeatInterval) {
                this.sendHearBeat();
            }
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public synchronized void login(LoginBuff.Login login) {
        try {
            this.login(login.toByteArray());
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    private void login(byte[] loginBodyBytes) throws Exception {
        this.lastLoginBodyBytes = loginBodyBytes;
        byte[] data = this.encoder.encode(false, false, false, this.getAppId(), (short)1, SegPackageUtil.getSerialNumber(), loginBodyBytes, this.getDESKey());
        this.send(data);
    }

    @Override
    public void logout() {
        try {
            try {
                byte[] body = new byte[]{};
                byte[] data = this.encoder.encode(false, false, false, this.getAppId(), (short)2, SegPackageUtil.getSerialNumber(), body, this.getDESKey());
                this.send(data);
                ClientManager.removeClient(this);
            }
            catch (Throwable e) {
                this.getHandler().exceptionCaught(e);
                this.disconnect();
            }
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public synchronized void send(byte[] data) {
        try {
            this.os.write(data);
            this.os.flush();
            this.SERVER_LAST_COMMUNICATE_TIME = System.currentTimeMillis();
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
            this.disconnect();
        }
    }

    private void dataReceived(byte[] data, int length) {
        if (this.usePackageMaker) {
            try {
                ByteBuffer buff = ByteBuffer.wrap(data, 0, length);
                this.packageMaker.dealData(buff, length);
            }
            catch (Throwable e) {
                this.getHandler().exceptionCaught(e);
                this.disconnect();
            }
        }
    }

    private class ReceiveDataThread
    extends Thread {
        private ReceiveDataThread() {
        }

        @Override
        public void run() {
            block8: {
                try {
                    try {
                        int len;
                        byte[] buff = new byte[1024];
                        while ((len = TCPClientImpl.this.is.read(buff)) > 0) {
                            TCPClientImpl.this.dataReceived(buff, len);
                        }
                    }
                    catch (Throwable e) {
                        TCPClientImpl.this.getHandler().exceptionCaught(e);
                        TCPClientImpl.this.disconnect();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    TCPClientImpl.this.disconnect();
                    throw throwable;
                }
                TCPClientImpl.this.disconnect();
            }
            TCPClientImpl.this.receiveDataThreadIsRunning = false;
            try {
                TCPClientImpl.this.getHandler().clientDisConnected();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

