/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.client.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.seg.lib.net.client.ClientImpl;
import org.seg.lib.net.client.manager.ClientManager;
import org.seg.lib.net.client.udp.UDPClient;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.util.IOUtil;
import org.seg.lib.util.SegPackageUtil;

public class UDPClientImpl
extends ClientImpl
implements UDPClient {
    private UDPClientImpl client = this;
    private boolean usePackageMaker = true;
    private DatagramSocket socket;
    private int dataBuffSize = 4096;
    private InetSocketAddress serverAddress;
    private long SERVER_LAST_COMMUNICATE_TIME = System.currentTimeMillis();
    private boolean runFlag = true;

    public UDPClientImpl(String serverIP, int serverPort) throws SocketException {
        this.sendHearBeatInterval = Long.MAX_VALUE;
        this.serverAddress = new InetSocketAddress(serverIP, serverPort);
        this.socket = new DatagramSocket();
        ReceiveDataThread receiveDataThread = new ReceiveDataThread();
        receiveDataThread.start();
    }

    public boolean isUsePackageMaker() {
        return this.usePackageMaker;
    }

    public void setUsePackageMaker(boolean usePackageMaker) {
        this.usePackageMaker = usePackageMaker;
    }

    @Override
    public void logout() {
        try {
            try {
                byte[] body = new byte[]{};
                byte[] data = this.encoder.encode(false, false, false, this.getAppId(), (short)2, SegPackageUtil.getSerialNumber(), body, this.getDESKey());
                this.send(data);
            }
            catch (Throwable e) {
                this.getHandler().exceptionCaught(e);
                this.closeClient();
                ClientManager.removeClient(this);
            }
        }
        finally {
            this.closeClient();
            ClientManager.removeClient(this);
        }
    }

    private void closeClient() {
        this.runFlag = false;
        IOUtil.closeSocket(this.socket);
    }

    @Override
    public void send(byte[] data) {
        try {
            DatagramPacket p = new DatagramPacket(data, 0, data.length, this.serverAddress);
            this.socket.send(p);
            this.SERVER_LAST_COMMUNICATE_TIME = System.currentTimeMillis();
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void timerTaskStart() {
        try {
            long now = System.currentTimeMillis();
            if (now - this.SERVER_LAST_COMMUNICATE_TIME >= this.sendHearBeatInterval) {
                this.sendHearBeat();
            }
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public int getDataBuffSize() {
        return this.dataBuffSize;
    }

    @Override
    public void setDataBuffSize(int size) {
        this.dataBuffSize = size;
    }

    private class ReceiveDataThread
    extends Thread {
        private ReceiveDataThread() {
        }

        @Override
        public void run() {
            byte[] data = new byte[UDPClientImpl.this.dataBuffSize];
            DatagramPacket packet = new DatagramPacket(data, 0, data.length);
            while (UDPClientImpl.this.runFlag) {
                try {
                    UDPClientImpl.this.socket.receive(packet);
                    UDPClientImpl.this.SERVER_LAST_COMMUNICATE_TIME = System.currentTimeMillis();
                    SegPackage pkg = SegPackage.parse(packet.getData(), packet.getOffset(), packet.getLength(), UDPClientImpl.this.getDESKey());
                    UDPClientImpl.this.getHandler().handlePackage(UDPClientImpl.this.client, pkg);
                }
                catch (Throwable e) {
                    UDPClientImpl.this.getHandler().exceptionCaught(e);
                }
            }
        }
    }
}

