/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import org.seg.lib.net.data.Head;
import org.seg.lib.util.Util;

public class SegPackage {
    private Head head;
    private byte[] body;
    private byte[] realBody;
    private byte[] end;
    private static final int HEAD_SIZE = 16;

    public Head getHead() {
        return this.head;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }

    public void setHead(Head head) {
        this.head = head;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getByteAll() {
        byte[] bsHead = this.head.getData();
        ByteBuffer buff = ByteBuffer.allocate(bsHead.length + this.body.length + this.end.length);
        buff.put(bsHead);
        buff.put(this.body);
        buff.put(this.end);
        return buff.array();
    }

    public byte[] getByteWithoutEnd() {
        byte[] bsHead = this.head.getData();
        ByteBuffer buff = ByteBuffer.allocate(bsHead.length + this.body.length);
        buff.put(bsHead);
        buff.put(this.body);
        return buff.array();
    }

    public byte[] getRealBody() {
        return this.realBody;
    }

    public void setRealBody(byte[] realBody) {
        this.realBody = realBody;
    }

    public static SegPackage parse(byte[] data, SecretKey key) throws Exception {
        return SegPackage.parse(data, 0, data.length, key);
    }

    public static SegPackage parse(byte[] data, int offset, int len, SecretKey key) throws Exception {
        int headLength = 16;
        if (len < headLength) {
            throw new IOException("data length less than min size, data length:" + len);
        }
        SegPackage pkg = new SegPackage();
        byte[] headBytes = new byte[headLength];
        System.arraycopy(data, offset, headBytes, 0, headLength);
        Head head = new Head();
        head.setData(headBytes);
        pkg.setHead(head);
        if (head.getStx() != -2) {
            throw new IOException("stx error:" + head.getStx());
        }
        int readLength = head.getLength();
        if (readLength != len) {
            throw new IOException("data length error, need length:" + readLength + ", received length:" + len);
        }
        int bodyLength = len - headLength - (head.isCRC() ? 4 : 0);
        byte[] bodyBytes = new byte[bodyLength];
        System.arraycopy(data, offset + headLength, bodyBytes, 0, bodyLength);
        pkg.setBody(bodyBytes);
        if (head.isCRC()) {
            byte[] end = new byte[4];
            System.arraycopy(data, offset + headLength + bodyLength, end, 0, 4);
            pkg.setEnd(end);
        }
        byte[] realBody = bodyBytes;
        if (head.isEncryption()) {
            realBody = Util.decodeDESC(key, realBody);
        }
        if (head.isCompressed()) {
            realBody = Util.ZlibDecompress(realBody);
        }
        pkg.setRealBody(realBody);
        SegPackage.checkCRC32(pkg);
        return pkg;
    }

    public static void checkCRC32(SegPackage pkg) throws IOException {
        byte[] bsWithoutEnd;
        int ccrc32;
        int scrc32;
        if (pkg.getHead().isCRC() && (scrc32 = Util.getInt(pkg.getEnd())) != (ccrc32 = (int)Util.CRC32C(bsWithoutEnd = pkg.getByteWithoutEnd()))) {
            throw new IOException("crc32 error,segPackage is:" + Util.getBytesString(pkg.getByteAll()));
        }
    }
}

