/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.encoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import org.seg.lib.net.encoder.PackageEncoder;
import org.seg.lib.util.Util;

public class SegPackageEncoder
implements PackageEncoder {
    @Override
    public byte[] encode(boolean isCompressed, boolean isEncrypt, boolean isCRC, int appId, short messageId, int serialNumber, byte[] bodyData, SecretKey desKey) throws IOException {
        byte[] body = bodyData;
        if (body == null) {
            body = new byte[]{};
        }
        if (isCompressed) {
            body = Util.ZlibCompress(body);
        }
        if (isEncrypt) {
            try {
                body = Util.encodeDESC(desKey, body);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ByteBuffer headBuff = this.getHeadBuff(isCompressed, isEncrypt, isCRC, appId, messageId, serialNumber, body.length);
        byte[] head = headBuff.array();
        ByteBuffer ack = ByteBuffer.allocate(head.length + body.length + (isCRC ? 4 : 0));
        ack.put(head);
        ack.put(body);
        if (isCRC) {
            int crc32 = (int)Util.CRC32C(ack.array(), 0, head.length + body.length);
            ack.putInt(crc32);
        }
        return ack.array();
    }

    private ByteBuffer getHeadBuff(boolean isCompressed, boolean isEncrypt, boolean isCRC, int appId, short messageId, int serialNumber, int bodyLength) {
        ByteBuffer buff = ByteBuffer.allocate(16);
        byte ecflag = 0;
        if (isCompressed) {
            ecflag = (byte)(ecflag | 0x80);
        }
        if (isEncrypt) {
            ecflag = (byte)(ecflag | 0x40);
        }
        if (isCRC) {
            ecflag = (byte)(ecflag | 1);
        }
        int length = 16 + bodyLength + (isCRC ? 4 : 0);
        buff.put((byte)-2);
        buff.put(ecflag);
        buff.putShort(messageId);
        buff.putInt(appId);
        buff.putInt(serialNumber);
        buff.putInt(length);
        return buff;
    }
}

