/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.encoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import javax.crypto.SecretKey;
import org.seg.lib.net.encoder.PackageEncoder;
import org.seg.lib.net.encoder.SegPackageEncoder;

public class WebSocketEncoder
implements PackageEncoder {
    private SegPackageEncoder segEncoder = new SegPackageEncoder();
    private boolean mask = false;
    private byte fin = 1;
    private byte rsv1 = 0;
    private byte rsv2 = 0;
    private byte rsv3 = 0;
    private byte defaultOpCode = (byte)2;
    private Random random = new Random();

    @Override
    public byte[] encode(boolean isCompressed, boolean isEncrypt, boolean isCRC, int appId, short messageId, int serialNumber, byte[] bodyData, SecretKey desKey) throws IOException {
        byte[] segdata = this.segEncoder.encode(isCompressed, isEncrypt, isCRC, appId, messageId, serialNumber, bodyData, desKey);
        return this.encode(segdata);
    }

    private byte getHead(byte opcode) {
        byte head = 0;
        head = (byte)(head | (this.fin == 1 ? 128 : 0));
        head = (byte)(head | (this.rsv1 == 1 ? 64 : 0));
        head = (byte)(head | (this.rsv2 == 1 ? 32 : 0));
        head = (byte)(head | (this.rsv3 == 1 ? 16 : 0));
        head = (byte)(head | opcode & 0xF);
        return head;
    }

    public byte[] encode(byte[] body) {
        return this.encode(body, this.defaultOpCode);
    }

    public byte[] encode(byte[] body, byte opCode) {
        byte[] length_byte;
        byte[] maskByte = null;
        if (this.mask) {
            maskByte = this.createMaskSeed();
            body = this.mask(body, maskByte);
        }
        byte head = this.getHead(opCode);
        if (body.length < 126) {
            length_byte = new byte[]{(byte)body.length};
        } else if (body.length <= 65535) {
            length_byte = new byte[]{126, (byte)(body.length >>> 8 & 0xFF), (byte)(body.length >>> 0 & 0xFF)};
        } else {
            length_byte = new byte[9];
            length_byte[0] = 127;
            long bodyLength = body.length;
            length_byte[1] = (byte)(bodyLength >>> 56 & 0xFFL);
            length_byte[2] = (byte)(bodyLength >>> 48 & 0xFFL);
            length_byte[3] = (byte)(bodyLength >>> 40 & 0xFFL);
            length_byte[4] = (byte)(bodyLength >>> 32 & 0xFFL);
            length_byte[5] = (byte)(bodyLength >>> 24 & 0xFFL);
            length_byte[6] = (byte)(bodyLength >>> 16 & 0xFFL);
            length_byte[7] = (byte)(bodyLength >>> 8 & 0xFFL);
            length_byte[8] = (byte)(bodyLength >>> 0 & 0xFFL);
        }
        if (this.mask) {
            length_byte[0] = (byte)(length_byte[0] | 0x80);
        }
        int total = 1 + length_byte.length + (this.mask ? 4 : 0) + body.length;
        ByteBuffer buff = ByteBuffer.allocate(total);
        buff.put(head);
        buff.put(length_byte);
        if (this.mask) {
            buff.put(maskByte);
        }
        buff.put(body);
        return buff.array();
    }

    private byte[] createMaskSeed() {
        byte[] maskByte = new byte[]{(byte)this.random.nextInt(256), (byte)this.random.nextInt(256), (byte)this.random.nextInt(256), (byte)this.random.nextInt(256)};
        return maskByte;
    }

    private byte[] mask(byte[] data, byte[] mask) {
        byte[] maskBytes = new byte[data.length];
        int mask_length = mask.length;
        int i = 0;
        while (i < data.length) {
            maskBytes[i] = (byte)(data[i] ^ mask[i % mask_length]);
            ++i;
        }
        return maskBytes;
    }
}

