/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.handler;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.data.Head;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.net.server.tcp.handler.TCPServerHandler;
import org.seg.lib.util.Util;

public class BaseTCPServerHandler
implements TCPServerHandler {
    @Override
    public void handlePackage(SegPackage pkg, TCPServer server, SocketSession session) throws Exception {
        if (pkg.getHead().getMessageId() == 1) {
            this.handleLogin(pkg, server, session);
        } else if (pkg.getHead().getMessageId() == 2) {
            this.handleLogout(pkg, server, session);
        } else if (pkg.getHead().getMessageId() == 3) {
            this.handleActiveTest(pkg, server, session);
        } else {
            this.handleOthers(pkg, server, session);
        }
    }

    protected void handleOthers(SegPackage pkg, TCPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        System.out.println("[BaseTCPServerHandler]received message, message Id is: " + head.getMessageId());
    }

    protected int checkLogin(LoginBuff.Login login) throws Exception {
        String userName = login.getUsername();
        String password = login.getPassword();
        if (!"admin".equals(userName)) {
            return 2;
        }
        if (!"pwd".equals(password)) {
            return 3;
        }
        return 0;
    }

    protected void handleLogin(SegPackage pkg, TCPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        int sequenceNo = head.getSequenceNo();
        byte[] realBody = pkg.getRealBody();
        LoginBuff.Login loginBuff = LoginBuff.Login.parseFrom(realBody);
        boolean isCRC = false;
        int loginResult = this.checkLogin(loginBuff);
        LoginAckBuff.LoginAck.Builder loginAckBuilder = LoginAckBuff.LoginAck.newBuilder();
        if (loginResult != 0) {
            loginAckBuilder.setResult(loginResult);
            byte[] loginAckBodyBuff = loginAckBuilder.build().toByteArray();
            session.sendPackage(false, false, isCRC, (short)-32767, sequenceNo, loginAckBodyBuff);
            return;
        }
        loginAckBuilder.setResult(0);
        session.setLogin(true);
        if (loginBuff.hasRsaModule() && loginBuff.hasRsaKey()) {
            byte[] rsaModuleBytes = loginBuff.getRsaModule().toByteArray();
            byte[] rsaPublicExponentBytes = loginBuff.getRsaKey().toByteArray();
            BigInteger rsaModule = new BigInteger(1, rsaModuleBytes);
            BigInteger publicExponent = new BigInteger(1, rsaPublicExponentBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaModule, publicExponent);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecureRandom random = new SecureRandom();
            byte[] desKeyBytes = random.generateSeed(8);
            DESKeySpec desKeySpec = new DESKeySpec(desKeyBytes);
            SecretKey DESKey = secretKeyFactory.generateSecret(desKeySpec);
            session.setDESKey(DESKey);
            byte[] rsaDesKeyBytes = Util.encodeRSA(publicKey, desKeyBytes);
            loginAckBuilder.setDesKey(ByteString.copyFrom((byte[])rsaDesKeyBytes));
        }
        byte[] bodyBytes = loginAckBuilder.build().toByteArray();
        session.sendPackage(false, false, isCRC, (short)-32767, sequenceNo, bodyBytes);
    }

    protected void handleActiveTest(SegPackage pkg, TCPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        int sequenceNo = head.getSequenceNo();
        session.sendPackage(false, false, false, (short)-32765, sequenceNo, null);
    }

    protected void handleLogout(SegPackage pkg, TCPServer server, SocketSession session) {
        session.close();
    }

    @Override
    public void exceptionCaught(Throwable e) {
        e.printStackTrace();
    }

    @Override
    public void clientConnected(TCPServer server, SocketSession session) {
    }

    @Override
    public void clientDisconnected(TCPServer server, SocketSession session) {
    }
}

