/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.netty;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.channel.Channel;
import org.seg.lib.net.server.tcp.BroadcastFilter;
import org.seg.lib.net.server.tcp.SessionManager;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.netty.NettyTCPServer;

public class NettySessionManager
implements SessionManager {
    private NettyTCPServer server;
    private Map<Channel, SocketSession> socketSessionMap = new ConcurrentHashMap<Channel, SocketSession>();
    private long runInterval = 60000L;
    private boolean runFlag = true;

    protected NettySessionManager(NettyTCPServer server) {
        this.server = server;
        this.startCheckAndClearThread();
    }

    protected void broadcastData(byte[] data, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        for (SocketSession session : this.socketSessionMap.values()) {
            if (session == exceptSession) continue;
            session.sendData(data);
        }
    }

    protected void broadcastDataToLogged(byte[] data, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        for (SocketSession session : this.socketSessionMap.values()) {
            if (!session.isLogin() || session == exceptSession) continue;
            session.sendData(data);
        }
    }

    protected void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        for (SocketSession session : this.socketSessionMap.values()) {
            try {
                if (session == exceptSession) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
    }

    protected void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, BroadcastFilter filter) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        for (SocketSession session : this.socketSessionMap.values()) {
            try {
                if (!filter.isSend(this.server, session)) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
    }

    protected void broadcastPackageToLogged(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        for (SocketSession session : this.socketSessionMap.values()) {
            try {
                if (!session.isLogin() || session == exceptSession) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
    }

    protected void addSession(Channel ch, SocketSession session) {
        this.socketSessionMap.put(ch, session);
    }

    public void removeSession(Channel ch) {
        ch.close();
        SocketSession session = this.socketSessionMap.remove(ch);
        if (session != null) {
            try {
                this.server.getHandler().clientDisconnected(this.server, session);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
    }

    public SocketSession getSession(Channel sc) {
        return this.socketSessionMap.get(sc);
    }

    private void checkAndClearSession() {
        long now = System.currentTimeMillis();
        for (Map.Entry<Channel, SocketSession> entry : this.socketSessionMap.entrySet()) {
            SocketSession session = entry.getValue();
            Channel channel = entry.getKey();
            if (now - session.getLastActiveTime() <= session.getMaxKeepAliveTime()) continue;
            this.removeSession(channel);
        }
    }

    private void startCheckAndClearThread() {
        CheckAndClearThread thread = new CheckAndClearThread();
        thread.start();
    }

    public Map<Channel, SocketSession> getSocketSessionMap() {
        return this.socketSessionMap;
    }

    @Override
    public Iterator<SocketSession> getSocketSessions() {
        return this.socketSessionMap.values().iterator();
    }

    private class CheckAndClearThread
    extends Thread {
        private CheckAndClearThread() {
        }

        @Override
        public void run() {
            while (NettySessionManager.this.runFlag) {
                try {
                    CheckAndClearThread.sleep(NettySessionManager.this.runInterval);
                    NettySessionManager.this.checkAndClearSession();
                }
                catch (Throwable e) {
                    NettySessionManager.this.server.getHandler().exceptionCaught(e);
                }
            }
        }
    }
}

