/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.seg.lib.net.encoder.PackageEncoder;
import org.seg.lib.net.encoder.SegPackageEncoder;
import org.seg.lib.net.encoder.WebSocketEncoder;
import org.seg.lib.net.server.tcp.BroadcastFilter;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.net.server.tcp.handler.BaseTCPServerHandler;
import org.seg.lib.net.server.tcp.handler.TCPServerHandler;
import org.seg.lib.net.server.tcp.netty.NettySessionManager;
import org.seg.lib.net.server.tcp.netty.SimpleNettyTCPHandler;

public class NettyTCPServer
implements TCPServer {
    private int port;
    private int appId = 102;
    private NettySessionManager sessionManager = new NettySessionManager(this);
    private PackageEncoder segPackageEncoder = new SegPackageEncoder();
    private PackageEncoder websocketPackageEncoder = new WebSocketEncoder();
    private boolean usePackageMaker = true;
    private TCPServerHandler handler = new BaseTCPServerHandler();
    private SimpleNettyTCPHandler nettyHandler = new SimpleNettyTCPHandler(this);
    private boolean isCompressed;
    private boolean isEncrypt;
    private boolean isCRC;

    public PackageEncoder getSegPackageEncoder() {
        return this.segPackageEncoder;
    }

    public void setSegPackageEncoder(PackageEncoder segPackageEncoder) {
        this.segPackageEncoder = segPackageEncoder;
    }

    public PackageEncoder getWebsocketPackageEncoder() {
        return this.websocketPackageEncoder;
    }

    public void setWebsocketPackageEncoder(PackageEncoder websocketPackageEncoder) {
        this.websocketPackageEncoder = websocketPackageEncoder;
    }

    public NettyTCPServer(int port) {
        this.port = port;
    }

    @Override
    public void startService() {
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{NettyTCPServer.this.nettyHandler});
            }
        });
        bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    @Override
    public void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        this.sessionManager.broadcastPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, exceptSession);
    }

    @Override
    public void broadcastPackageToLogged(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        this.sessionManager.broadcastPackageToLogged(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, exceptSession);
    }

    @Override
    public void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, BroadcastFilter filter) {
        this.sessionManager.broadcastPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, filter);
    }

    public void broadcastData(byte[] data, SocketSession exceptSession) {
        this.sessionManager.broadcastData(data, exceptSession);
    }

    public void broadcastDataToLogged(byte[] data, SocketSession exceptSession) {
        this.sessionManager.broadcastDataToLogged(data, exceptSession);
    }

    @Override
    public NettySessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isUsePackageMaker() {
        return this.usePackageMaker;
    }

    public void setUsePackageMaker(boolean usePackageMaker) {
        this.usePackageMaker = usePackageMaker;
    }

    @Override
    public int getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(int appId) {
        this.appId = appId;
    }

    @Override
    public TCPServerHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(TCPServerHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getConnectionCount() {
        return this.sessionManager.getSocketSessionMap().size();
    }

    @Override
    public void setDefaultIsCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public void setDefaultIsEncrypt(boolean isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    @Override
    public void setDefaultIsCRC(boolean isCRC) {
        this.isCRC = isCRC;
    }

    @Override
    public boolean getDefaultIsCompressed() {
        return this.isCompressed;
    }

    @Override
    public boolean getDefaultIsEncrypt() {
        return this.isEncrypt;
    }

    @Override
    public boolean getDefaultIsCRC() {
        return this.isCRC;
    }
}

