/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.netty;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.netty.NettySocketSession;
import org.seg.lib.net.server.tcp.netty.NettyTCPServer;
import org.seg.lib.net.server.tcp.pkg.SegPackageMaker;
import org.seg.lib.net.server.tcp.pkg.WebSocketPackageMaker;
import org.seg.lib.stream.PackageMaker;

public class SimpleNettyTCPHandler
extends SimpleChannelUpstreamHandler {
    private NettyTCPServer server;

    public SimpleNettyTCPHandler(NettyTCPServer server) {
        this.server = server;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Channel channel = e.getChannel();
        ChannelBuffer buff0 = (ChannelBuffer)e.getMessage();
        int length = buff0.readableBytes();
        ByteBuffer buff = buff0.toByteBuffer();
        SocketSession session = this.server.getSessionManager().getSession(channel);
        if (session == null) {
            return;
        }
        session.setLastActiveTime(System.currentTimeMillis());
        try {
            if (this.server.isUsePackageMaker()) {
                PackageMaker packageMaker = session.getPackageMaker();
                if (packageMaker != null) {
                    packageMaker.dealData(buff, length);
                } else {
                    byte first = buff.array()[0];
                    if (first == -2) {
                        SegPackageMaker pm = new SegPackageMaker(this.server, session);
                        session.setPackageMaker(pm);
                        session.setPackageEncoder(this.server.getSegPackageEncoder());
                        pm.dealData(buff, length);
                    } else if (first == 71) {
                        WebSocketPackageMaker pm = new WebSocketPackageMaker(this.server, session);
                        session.setPackageMaker(pm);
                        session.setPackageEncoder(this.server.getWebsocketPackageEncoder());
                        pm.dealData(buff, length);
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Throwable e1) {
            this.server.getHandler().exceptionCaught(e1);
            e.getChannel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.server.getHandler().exceptionCaught(e.getCause());
        e.getChannel().close();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        LinkedList atm = new LinkedList();
        channel.setAttachment(atm);
        NettySocketSession session = new NettySocketSession(this.server, channel);
        this.server.getSessionManager().addSession(channel, session);
        this.server.getHandler().clientConnected(this.server, session);
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SocketSession session = this.server.getSessionManager().getSession(e.getChannel());
        if (session == null) {
            return;
        }
        this.server.getSessionManager().removeSession(e.getChannel());
        super.channelDisconnected(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LinkedList list;
        Channel channel = e.getChannel();
        LinkedList linkedList = list = (LinkedList)channel.getAttachment();
        synchronized (linkedList) {
            while (list.size() > 0) {
                if (!channel.isWritable()) break;
                byte[] data = (byte[])list.poll();
                ChannelBuffer tosend = ChannelBuffers.wrappedBuffer((byte[])data);
                channel.write((Object)tosend);
            }
        }
    }
}

