/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.nio;

import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seg.lib.net.server.tcp.BroadcastFilter;
import org.seg.lib.net.server.tcp.SessionManager;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.nio.NIOTCPServer;
import org.seg.lib.util.IOUtil;

public class NIOSessionManager
implements SessionManager {
    private NIOTCPServer server;
    private Map<SocketChannel, SocketSession> socketSessionMap = new ConcurrentHashMap<SocketChannel, SocketSession>();
    private long runInterval = 60000L;
    private boolean runFlag = true;

    protected NIOSessionManager(NIOTCPServer server) {
        this.server = server;
        this.startCheckAndClearThread();
    }

    protected void broadcastData(byte[] data, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        Iterator<SocketSession> it = this.socketSessionMap.values().iterator();
        Selector selector = this.server.getSelector();
        while (it.hasNext()) {
            SocketSession session = it.next();
            if (session == exceptSession) continue;
            session.sendData(data);
        }
        selector.wakeup();
    }

    protected void broadcastDataToLogged(byte[] data, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        Iterator<SocketSession> it = this.socketSessionMap.values().iterator();
        Selector selector = this.server.getSelector();
        while (it.hasNext()) {
            SocketSession session = it.next();
            if (!session.isLogin() || session == exceptSession) continue;
            try {
                session.sendData(data);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
        selector.wakeup();
    }

    protected void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        Iterator<SocketSession> it = this.socketSessionMap.values().iterator();
        Selector selector = this.server.getSelector();
        while (it.hasNext()) {
            SocketSession session = it.next();
            try {
                if (session == exceptSession) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
        selector.wakeup();
    }

    protected void broadcastPackageToLogged(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        Iterator<SocketSession> it = this.socketSessionMap.values().iterator();
        Selector selector = this.server.getSelector();
        while (it.hasNext()) {
            SocketSession session = it.next();
            try {
                if (!session.isLogin() || session == exceptSession) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
        selector.wakeup();
    }

    protected void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, BroadcastFilter filter) {
        if (this.socketSessionMap.size() == 0) {
            return;
        }
        Iterator<SocketSession> it = this.socketSessionMap.values().iterator();
        Selector selector = this.server.getSelector();
        while (it.hasNext()) {
            SocketSession session = it.next();
            try {
                if (!filter.isSend(this.server, session)) continue;
                session.sendPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData);
            }
            catch (Throwable e) {
                this.server.getHandler().exceptionCaught(e);
            }
        }
        selector.wakeup();
    }

    protected void addSession(SocketChannel sc, SocketSession session) {
        this.socketSessionMap.put(sc, session);
    }

    public void removeSession(SocketChannel sc) {
        IOUtil.closeSocketChannel(sc);
        SocketSession session = this.socketSessionMap.remove(sc);
        try {
            this.server.getHandler().clientDisconnected(this.server, session);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }

    public SocketSession getSession(SocketChannel sc) {
        return this.socketSessionMap.get(sc);
    }

    private void checkAndClearSession() {
        long now = System.currentTimeMillis();
        for (Map.Entry<SocketChannel, SocketSession> entry : this.socketSessionMap.entrySet()) {
            SocketSession session = entry.getValue();
            SocketChannel sc = entry.getKey();
            if (now - session.getLastActiveTime() <= session.getMaxKeepAliveTime()) continue;
            this.removeSession(sc);
        }
    }

    private void startCheckAndClearThread() {
        CheckAndClearThread thread = new CheckAndClearThread();
        thread.start();
    }

    public Map<SocketChannel, SocketSession> getSocketSessionMap() {
        return this.socketSessionMap;
    }

    @Override
    public Iterator<SocketSession> getSocketSessions() {
        return this.socketSessionMap.values().iterator();
    }

    private class CheckAndClearThread
    extends Thread {
        private CheckAndClearThread() {
        }

        @Override
        public void run() {
            while (NIOSessionManager.this.runFlag) {
                try {
                    CheckAndClearThread.sleep(NIOSessionManager.this.runInterval);
                    NIOSessionManager.this.checkAndClearSession();
                }
                catch (Throwable e) {
                    NIOSessionManager.this.server.getHandler().exceptionCaught(e);
                }
            }
        }
    }
}

