/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.nio;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.seg.lib.net.encoder.PackageEncoder;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.nio.NIOTCPServer;
import org.seg.lib.stream.PackageMaker;

public class NIOSocketSession
implements SocketSession {
    private PackageMaker packageMaker;
    private PackageEncoder packageEncoder;
    private SecretKey DESKey;
    protected List<ByteBuffer> sendBuff = new ArrayList<ByteBuffer>();
    private SocketChannel socketChannel;
    private long lastActiveTime = System.currentTimeMillis();
    private long maxKeepAliveTime = 300000L;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private NIOTCPServer server;
    private boolean isLogin;
    private long createTime = System.currentTimeMillis();

    public NIOSocketSession(NIOTCPServer server, SocketChannel socketChannel) {
        this.server = server;
        this.socketChannel = socketChannel;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object obj) {
        this.attributes.put(key, obj);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    @Override
    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    @Override
    public long getMaxKeepAliveTime() {
        return this.maxKeepAliveTime;
    }

    @Override
    public void setMaxKeepAliveTime(long maxKeepAliveTime) {
        this.maxKeepAliveTime = maxKeepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(byte[] data) {
        try {
            List<ByteBuffer> list = this.sendBuff;
            synchronized (list) {
                this.sendBuff.add(ByteBuffer.wrap(data));
            }
            SelectionKey key = this.getSocketChannel().keyFor(this.server.getSelector());
            key.interestOps(4);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void sendPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData) {
        try {
            byte[] data = this.getPackageEncoder().encode(isCompressed, isEncrypt, isCRC, this.server.getAppId(), messageId, serialNumber, bodyData, this.getDESKey());
            this.sendData(data);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public PackageMaker getPackageMaker() {
        return this.packageMaker;
    }

    @Override
    public void setPackageMaker(PackageMaker packageMaker) {
        this.packageMaker = packageMaker;
    }

    @Override
    public PackageEncoder getPackageEncoder() {
        return this.packageEncoder;
    }

    @Override
    public void setPackageEncoder(PackageEncoder packageEncoder) {
        this.packageEncoder = packageEncoder;
    }

    @Override
    public SecretKey getDESKey() {
        return this.DESKey;
    }

    @Override
    public void setDESKey(SecretKey dESKey) {
        this.DESKey = dESKey;
    }

    @Override
    public boolean isLogin() {
        return this.isLogin;
    }

    @Override
    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    @Override
    public void close() {
        this.server.closeClient(this.socketChannel);
    }

    @Override
    public void sendPackage(short messageId, int serialNumber, byte[] bodyData) {
        this.sendPackage(this.server.getDefaultIsCompressed(), this.server.getDefaultIsEncrypt(), this.server.getDefaultIsCRC(), messageId, serialNumber, bodyData);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.socketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.socketChannel.socket().getLocalSocketAddress();
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }
}

