/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import org.seg.lib.net.encoder.PackageEncoder;
import org.seg.lib.net.encoder.SegPackageEncoder;
import org.seg.lib.net.encoder.WebSocketEncoder;
import org.seg.lib.net.server.tcp.BroadcastFilter;
import org.seg.lib.net.server.tcp.SessionManager;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.net.server.tcp.handler.BaseTCPServerHandler;
import org.seg.lib.net.server.tcp.handler.TCPServerHandler;
import org.seg.lib.net.server.tcp.nio.NIOSessionManager;
import org.seg.lib.net.server.tcp.nio.NIOSocketSession;
import org.seg.lib.net.server.tcp.pkg.SegPackageMaker;
import org.seg.lib.net.server.tcp.pkg.WebSocketPackageMaker;
import org.seg.lib.stream.PackageMaker;

public class NIOTCPServer
implements TCPServer {
    private NIOTCPServer server = this;
    private int port;
    private int appId = 101;
    private Selector selector;
    private NIOSessionManager sessionManager = new NIOSessionManager(this);
    private PackageEncoder segPackageEncoder = new SegPackageEncoder();
    private PackageEncoder websocketPackageEncoder = new WebSocketEncoder();
    private boolean usePackageMaker = true;
    private TCPServerHandler handler = new BaseTCPServerHandler();
    private boolean serviceFlag = true;
    private ByteBuffer readBuffer = ByteBuffer.allocate(10240);
    private boolean isCompressed;
    private boolean isEncrypt;
    private boolean isCRC;

    public NIOTCPServer(int port) {
        this.port = port;
    }

    @Override
    public void startService() {
        Thread serviceThread = new Thread(new ServiceThread());
        serviceThread.start();
    }

    private void doAccept(SelectionKey key) {
        SelectableChannel channel = key.channel();
        ServerSocketChannel ssc = (ServerSocketChannel)channel;
        try {
            SocketChannel sc = ssc.accept();
            sc.configureBlocking(false);
            sc.register(key.selector(), 1);
            NIOSocketSession session = new NIOSocketSession(this, sc);
            this.sessionManager.addSession(sc, session);
            this.getHandler().clientConnected(this.server, session);
        }
        catch (IOException e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    private void doRead(SelectionKey key) {
        SelectableChannel channel = key.channel();
        SocketChannel sc = (SocketChannel)channel;
        this.readBuffer.clear();
        try {
            int len = sc.read(this.readBuffer);
            if (len == -1) {
                this.closeClient(sc);
            } else {
                this.dataReceived(key, this.readBuffer, len);
            }
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
            this.closeClient(sc);
        }
    }

    private void dataReceived(SelectionKey key, ByteBuffer buff, int length) throws Exception {
        SocketChannel sc = (SocketChannel)key.channel();
        buff.flip();
        SocketSession session = this.sessionManager.getSession(sc);
        if (session == null) {
            return;
        }
        session.setLastActiveTime(System.currentTimeMillis());
        if (this.usePackageMaker) {
            PackageMaker packageMaker = session.getPackageMaker();
            if (packageMaker != null) {
                packageMaker.dealData(buff, length);
            } else {
                byte first = buff.array()[0];
                if (first == -2) {
                    SegPackageMaker pm = new SegPackageMaker(this.server, session);
                    session.setPackageMaker(pm);
                    session.setPackageEncoder(this.segPackageEncoder);
                    pm.dealData(buff, length);
                } else if (first == 71) {
                    WebSocketPackageMaker pm = new WebSocketPackageMaker(this.server, session);
                    session.setPackageMaker(pm);
                    session.setPackageEncoder(this.websocketPackageEncoder);
                    pm.dealData(buff, length);
                } else {
                    this.closeClient(sc);
                    throw new IOException("unkown type:" + first);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        NIOSocketSession session = (NIOSocketSession)this.sessionManager.getSession(sc);
        if (session != null) {
            session.setLastActiveTime(System.currentTimeMillis());
            try {
                List<ByteBuffer> list = session.sendBuff;
                synchronized (list) {
                    ByteBuffer buff = session.sendBuff.remove(0);
                    sc.write(buff);
                    buff.compact();
                    if (session.sendBuff.size() == 0) {
                        key.interestOps(1);
                    }
                }
            }
            catch (Throwable e) {
                this.getHandler().exceptionCaught(e);
                this.closeClient(sc);
            }
        }
    }

    public void closeClient(SocketChannel sc) {
        SocketSession session = this.sessionManager.getSession(sc);
        if (session == null) {
            return;
        }
        this.sessionManager.removeSession(sc);
    }

    @Override
    public void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        this.sessionManager.broadcastPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, exceptSession);
    }

    @Override
    public void broadcastPackageToLogged(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, SocketSession exceptSession) {
        this.sessionManager.broadcastPackageToLogged(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, exceptSession);
    }

    @Override
    public void broadcastPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData, BroadcastFilter filter) {
        this.sessionManager.broadcastPackage(isCompressed, isEncrypt, isCRC, messageId, serialNumber, bodyData, filter);
    }

    public void broadcastData(byte[] data, SocketSession exceptSession) {
        this.sessionManager.broadcastData(data, exceptSession);
    }

    public void broadcastDataToLogged(byte[] data, SocketSession exceptSession) {
        this.sessionManager.broadcastDataToLogged(data, exceptSession);
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean isUsePackageMaker() {
        return this.usePackageMaker;
    }

    public void setUsePackageMaker(boolean usePackageMaker) {
        this.usePackageMaker = usePackageMaker;
    }

    @Override
    public int getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(int appId) {
        this.appId = appId;
    }

    @Override
    public TCPServerHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(TCPServerHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getConnectionCount() {
        return this.sessionManager.getSocketSessionMap().size();
    }

    @Override
    public void setDefaultIsCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public void setDefaultIsEncrypt(boolean isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    @Override
    public void setDefaultIsCRC(boolean isCRC) {
        this.isCRC = isCRC;
    }

    @Override
    public boolean getDefaultIsCompressed() {
        return this.isCompressed;
    }

    @Override
    public boolean getDefaultIsEncrypt() {
        return this.isEncrypt;
    }

    @Override
    public boolean getDefaultIsCRC() {
        return this.isCRC;
    }

    private class ServiceThread
    implements Runnable {
        private ServiceThread() {
        }

        @Override
        public void run() {
            ServerSocketChannel ssc = null;
            try {
                NIOTCPServer.this.selector = Selector.open();
                ssc = ServerSocketChannel.open();
                ssc.socket().bind(new InetSocketAddress(NIOTCPServer.this.port));
                ssc.configureBlocking(false);
                ssc.register(NIOTCPServer.this.selector, 16);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            System.out.println("tcp server ready![" + NIOTCPServer.this.port + "]");
            while (NIOTCPServer.this.serviceFlag) {
                try {
                    NIOTCPServer.this.selector.select();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                Iterator<SelectionKey> it = NIOTCPServer.this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    try {
                        if (key.isAcceptable()) {
                            NIOTCPServer.this.doAccept(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            NIOTCPServer.this.doRead(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        NIOTCPServer.this.doWrite(key);
                    }
                    catch (Throwable e) {
                        NIOTCPServer.this.getHandler().exceptionCaught(e);
                    }
                }
            }
        }
    }
}

