/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.pkg;

import java.nio.ByteBuffer;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.stream.BaseStreamAnalysor;
import org.seg.lib.stream.PackageHandler;
import org.seg.lib.stream.PackageMaker;
import org.seg.lib.stream.StreamAnalysor;

public class SegPackageMaker
implements PackageMaker,
PackageHandler {
    private StreamAnalysor analysor = new BaseStreamAnalysor(this);
    private TCPServer server;
    private SocketSession session;

    public SegPackageMaker(TCPServer server, SocketSession session) {
        this.server = server;
        this.session = session;
    }

    @Override
    public void dealData(ByteBuffer buff, int len) throws Exception {
        this.analysor.handleStream(buff, len);
    }

    @Override
    public void packageReceived(byte[] pkg) {
        try {
            SegPackage segpkg = SegPackage.parse(pkg, this.session.getDESKey());
            this.server.getHandler().handlePackage(segpkg, this.server, this.session);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }
}

