/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.tcp.pkg;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.encoder.WebSocketEncoder;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.stream.PackageMaker;
import sun.misc.BASE64Encoder;

public class WebSocketPackageMaker
implements PackageMaker {
    private boolean isHeadCheckEnd = false;
    private TCPServer server;
    private SocketSession session;
    private static final int HEAD_SIZE = 2;
    private List<byte[]> headByteList = new ArrayList<byte[]>();
    private List<byte[]> extendedHeadByteList = new ArrayList<byte[]>();
    private List<byte[]> maskByteList = new ArrayList<byte[]>();
    private List<byte[]> bodyByteList = new ArrayList<byte[]>();
    private int headNeed = 2;
    private int extendedHeadNeed = 0;
    private int maskNeed = 0;
    private int bodyNeed = 0;
    private int extendedHeadSize = 0;
    private int bodySize = 0;
    private byte[] headBytesTemp = null;
    private WebSocketEncoder encoder2 = new WebSocketEncoder();
    private List<byte[]> httpHeadList = new ArrayList<byte[]>();
    private int status = 0;
    private String guid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private BASE64Encoder encoder = new BASE64Encoder();

    public WebSocketPackageMaker(TCPServer server, SocketSession session) {
        this.server = server;
        this.session = session;
    }

    private void reset() {
        this.headByteList.clear();
        this.extendedHeadByteList.clear();
        this.maskByteList.clear();
        this.bodyByteList.clear();
        this.headNeed = 2;
        this.extendedHeadNeed = 0;
        this.maskNeed = 0;
        this.bodyNeed = 0;
        this.extendedHeadSize = 0;
        this.bodySize = 0;
    }

    private void setUpHead() {
        ByteBuffer buff = ByteBuffer.allocate(2);
        for (byte[] b : this.headByteList) {
            buff.put(b);
        }
        this.headBytesTemp = buff.array();
    }

    private int calLength1() {
        byte len = this.headBytesTemp[1];
        len = (byte)(len & 0x7F);
        return len;
    }

    private long calLength2() {
        ByteBuffer buff = ByteBuffer.allocate(this.extendedHeadSize);
        for (byte[] b : this.extendedHeadByteList) {
            buff.put(b);
        }
        buff.flip();
        if (this.extendedHeadSize == 2) {
            return buff.getShort() & 0xFFFF;
        }
        return buff.getLong();
    }

    private boolean isMask() {
        byte mask = this.headBytesTemp[1];
        return (mask & 0x80) != 0;
    }

    private byte[] maskX(byte[] data, byte[] mask) {
        byte[] maskBytes = new byte[data.length];
        int mask_length = mask.length;
        int i = 0;
        while (i < data.length) {
            maskBytes[i] = (byte)(data[i] ^ mask[i % mask_length]);
            ++i;
        }
        return maskBytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealPackage(TCPServer server, SocketSession session) throws Exception {
        try {
            byte opCode = (byte)(this.headBytesTemp[0] & 0xF);
            if (opCode == 8) {
                session.close();
                return;
            }
            if (opCode == 9 || opCode == 10) {
                System.out.println("ping or pong, opCode:" + opCode);
                return;
            }
            ByteBuffer bodyBuff = ByteBuffer.allocate(this.bodySize);
            for (byte[] b : this.bodyByteList) {
                bodyBuff.put(b);
            }
            byte[] bodyBytes = bodyBuff.array();
            if (this.isMask()) {
                ByteBuffer maskBuff = ByteBuffer.allocate(4);
                for (byte[] b : this.maskByteList) {
                    maskBuff.put(b);
                }
                byte[] mask = maskBuff.array();
                bodyBytes = this.maskX(bodyBytes, mask);
            }
            if (opCode == 1) {
                String returnStr = new String(bodyBytes, "utf-8");
                session.sendData(this.encoder2.encode(returnStr.getBytes("utf-8"), (byte)1));
                return;
            }
            SegPackage pkg = SegPackage.parse(bodyBytes, session.getDESKey());
            server.getHandler().handlePackage(pkg, server, session);
            return;
        }
        finally {
            this.reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void dealData(ByteBuffer buff, int len) throws Exception {
        if (this.isHeadCheckEnd) ** GOTO lbl97
        this.checkHead(this.server, this.session, buff, len);
        return;
lbl-1000:
        // 1 sources

        {
            if (this.headNeed == 0 && this.extendedHeadNeed == 0 && this.maskNeed == 0 && this.bodyNeed == 0) {
                this.reset();
                throw new IOException("###error:0 0  left:" + leftBytes);
            }
            if (this.headNeed > 0) {
                if (leftBytes < this.headNeed) {
                    temp = new byte[leftBytes];
                    buff.get(temp);
                    if (this.headNeed == 2 && (temp[0] & 112) != 0) {
                        throw new IOException("stx is wrong:" + temp[0]);
                    }
                    this.headByteList.add(temp);
                    this.headNeed -= leftBytes;
                    break;
                }
                temp = new byte[this.headNeed];
                buff.get(temp);
                if (this.headNeed == 2 && (temp[0] & 112) != 0) {
                    throw new IOException("stx is wrong:" + temp[0]);
                }
                this.headByteList.add(temp);
                this.headNeed = 0;
                this.setUpHead();
                len1 = this.calLength1();
                v0 = this.maskNeed = this.isMask() != false ? 4 : 0;
                if (len1 == 126) {
                    this.extendedHeadNeed = 2;
                    this.extendedHeadSize = 2;
                    continue;
                }
                if (len1 == 127) {
                    this.extendedHeadNeed = 8;
                    this.extendedHeadSize = 8;
                    continue;
                }
                this.extendedHeadNeed = 0;
                this.extendedHeadSize = 0;
                this.bodyNeed = len1;
                this.bodySize = len1;
                if (this.maskNeed != 0 || this.bodyNeed != 0) continue;
                this.dealPackage(this.server, this.session);
                continue;
            }
            if (this.extendedHeadNeed > 0) {
                if (leftBytes < this.extendedHeadNeed) {
                    temp = new byte[leftBytes];
                    buff.get(temp);
                    this.extendedHeadByteList.add(temp);
                    this.extendedHeadNeed -= leftBytes;
                    break;
                }
                temp = new byte[this.extendedHeadNeed];
                buff.get(temp);
                this.extendedHeadByteList.add(temp);
                this.extendedHeadNeed = 0;
                len2 = this.calLength2();
                this.bodyNeed = (int)len2;
                this.bodySize = (int)len2;
                continue;
            }
            if (this.maskNeed > 0) {
                if (leftBytes < this.maskNeed) {
                    temp = new byte[leftBytes];
                    buff.get(temp);
                    this.maskByteList.add(temp);
                    this.maskNeed -= leftBytes;
                    break;
                }
                temp = new byte[this.maskNeed];
                buff.get(temp);
                this.maskByteList.add(temp);
                this.maskNeed = 0;
                if (this.bodyNeed != 0) continue;
                this.dealPackage(this.server, this.session);
                continue;
            }
            if (this.bodyNeed <= 0) continue;
            if (leftBytes < this.bodyNeed) {
                temp = new byte[leftBytes];
                buff.get(temp);
                this.bodyByteList.add(temp);
                this.bodyNeed -= leftBytes;
                break;
            }
            temp = new byte[this.bodyNeed];
            buff.get(temp);
            this.bodyByteList.add(temp);
            this.bodyNeed = 0;
            this.dealPackage(this.server, this.session);
lbl97:
            // 10 sources

            ** while ((leftBytes = buff.limit() - buff.position()) > 0)
        }
lbl98:
        // 5 sources

    }

    private void checkHead(TCPServer server, SocketSession session, ByteBuffer buff, int len) throws Exception {
        byte[] bs = new byte[len];
        buff.get(bs);
        this.checkHead(server, session, bs);
    }

    private void checkHead(TCPServer server, SocketSession session, byte[] bs) throws Exception {
        int i = 0;
        while (i < bs.length) {
            if (bs[i] == 13) {
                this.status = this.status == 2 ? 3 : 1;
            } else if (bs[i] == 10) {
                if (this.status == 1) {
                    this.status = 2;
                } else {
                    if (this.status == 3) {
                        this.status = 4;
                        this.isHeadCheckEnd = true;
                        byte[] current = bs;
                        if (i != bs.length - 1) {
                            current = new byte[i + 1];
                            System.arraycopy(bs, 0, current, 0, i + 1);
                        }
                        this.httpHeadList.add(current);
                        this.dealHttpHead(server, session, this.httpHeadList);
                        if (i != bs.length - 1) {
                            int leftLength = bs.length - i - 1;
                            ByteBuffer leftBuff = ByteBuffer.allocate(leftLength);
                            leftBuff.put(bs, i + 1, leftLength);
                            this.dealData(leftBuff, leftLength);
                        }
                        return;
                    }
                    this.status = 0;
                }
            } else {
                this.status = 0;
            }
            ++i;
        }
        this.httpHeadList.add(bs);
        if (this.httpHeadList.size() > 10) {
            throw new IOException("big http head, size:" + this.httpHeadList.size());
        }
    }

    private void dealHttpHead(TCPServer server, SocketSession session, List<byte[]> httpHeadList) throws Exception {
        int count = 0;
        int i = 0;
        while (i < httpHeadList.size()) {
            count += httpHeadList.get(i).length;
            ++i;
        }
        ByteBuffer buff = ByteBuffer.allocate(count);
        int i2 = 0;
        while (i2 < httpHeadList.size()) {
            buff.put(httpHeadList.get(i2));
            ++i2;
        }
        byte[] headBytes = buff.array();
        String info = new String(headBytes, "UTF-8");
        String versionFlag = "Sec-WebSocket-Version:";
        int versionStartIndex = info.indexOf(versionFlag);
        String version = null;
        if (versionStartIndex != -1) {
            int versionEndIndex = info.indexOf("\r\n", versionStartIndex);
            version = info.substring(versionStartIndex + versionFlag.length(), versionEndIndex).trim();
        }
        if (!"13".equals(version)) {
            throw new IOException("not support version:" + version);
        }
        String secKey = this.getInfoByKey("Sec-WebSocket-Key:", info);
        if (secKey != null) {
            String resKey = this.getSecWebSocketAccept(secKey);
            String response = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + resKey + "\r\n\r\n";
            session.sendData(response.getBytes("UTF-8"));
        } else {
            System.out.println("secKey is null");
        }
    }

    private String getInfoByKey(String keyFlag, String info) {
        int keyStartIndex = info.indexOf(keyFlag);
        if (keyStartIndex != -1) {
            int keyEndIndex = info.indexOf("\r\n", keyStartIndex);
            String value = info.substring(keyStartIndex + keyFlag.length(), keyEndIndex).trim();
            return value;
        }
        return null;
    }

    private String getSecWebSocketAccept(String key) throws Exception {
        String addKey = String.valueOf(key) + this.guid;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(addKey.getBytes("utf-8"), 0, addKey.length());
        byte[] sha1Hash = md.digest();
        String returnKey = this.base64Encode(sha1Hash);
        return returnKey;
    }

    private String base64Encode(byte[] input) {
        return this.encoder.encode(input);
    }
}

