/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.udp.handler;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.data.Head;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.server.udp.SocketSession;
import org.seg.lib.net.server.udp.UDPServer;
import org.seg.lib.net.server.udp.handler.UDPServerHandler;
import org.seg.lib.util.Util;

public class BaseUDPServerHandler
implements UDPServerHandler {
    @Override
    public void handlePackage(byte[] data, int offset, int length, UDPServer server, SocketSession session) throws Exception {
        SegPackage pkg = SegPackage.parse(data, offset, length, null);
        if (pkg.getHead().getMessageId() == 1) {
            this.handleLogin(pkg, server, session);
        } else if (pkg.getHead().getMessageId() == 2) {
            this.handleLogout(pkg, server, session);
        } else if (pkg.getHead().getMessageId() == 3) {
            this.handleActiveTest(pkg, server, session);
        } else {
            this.handleOthers(pkg, server, session);
        }
    }

    protected void handleOthers(SegPackage pkg, UDPServer server, SocketSession session) throws Exception {
        System.out.println("[BaseUDPServerHandler]received message, message Id is: " + pkg.getHead().getMessageId());
    }

    protected void handleLogout(SegPackage pkg, UDPServer server, SocketSession session) {
    }

    protected int checkLogin(LoginBuff.Login login) {
        String userName = login.getUsername();
        String password = login.getPassword();
        if (!"admin".equals(userName)) {
            return 2;
        }
        if (!"pwd".equals(password)) {
            return 3;
        }
        return 0;
    }

    protected void handleLogin(SegPackage pkg, UDPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        int sequenceNo = head.getSequenceNo();
        byte[] realBody = pkg.getRealBody();
        LoginBuff.Login loginBuff = LoginBuff.Login.parseFrom(realBody);
        int loginResult = this.checkLogin(loginBuff);
        LoginAckBuff.LoginAck.Builder loginAckBuilder = LoginAckBuff.LoginAck.newBuilder();
        if (loginResult != 0) {
            loginAckBuilder.setResult(loginResult);
            byte[] loginAckBodyBuff = loginAckBuilder.build().toByteArray();
            session.sendPackage(false, false, false, (short)-32767, sequenceNo, loginAckBodyBuff);
            return;
        }
        loginAckBuilder.setResult(0);
        if (loginBuff.hasRsaModule() && loginBuff.hasRsaKey()) {
            byte[] rsaModuleBytes = loginBuff.getRsaModule().toByteArray();
            byte[] rsaPublicExponentBytes = loginBuff.getRsaKey().toByteArray();
            BigInteger rsaModule = new BigInteger(1, rsaModuleBytes);
            BigInteger publicExponent = new BigInteger(1, rsaPublicExponentBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaModule, publicExponent);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            SecureRandom random = new SecureRandom();
            byte[] desKeyBytes = random.generateSeed(8);
            byte[] rsaDesKeyBytes = Util.encodeRSA(publicKey, desKeyBytes);
            loginAckBuilder.setDesKey(ByteString.copyFrom((byte[])rsaDesKeyBytes));
        }
        byte[] bodyBytes = loginAckBuilder.build().toByteArray();
        session.sendPackage(false, false, false, (short)-32767, sequenceNo, bodyBytes);
    }

    protected void handleActiveTest(SegPackage pkg, UDPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        int sequenceNo = head.getSequenceNo();
        session.sendPackage(false, false, false, (short)-32765, sequenceNo, new byte[0]);
    }

    @Override
    public void exceptionCaught(Throwable e) {
        e.printStackTrace();
    }
}

