/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.udp.netty;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.seg.lib.net.encoder.SegPackageEncoder;
import org.seg.lib.net.server.udp.SocketSession;
import org.seg.lib.net.server.udp.UDPServer;

public class NettySocketSession
implements SocketSession {
    private UDPServer server;
    private Channel channel;
    private SocketAddress remoteAddress;
    private SegPackageEncoder encoder = new SegPackageEncoder();

    public NettySocketSession(UDPServer server, Channel channel, SocketAddress remoteAddress) {
        this.server = server;
        this.channel = channel;
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void sendData(byte[] data) {
        ChannelBuffer send = ChannelBuffers.wrappedBuffer((byte[])data);
        this.channel.write((Object)send, this.remoteAddress);
    }

    @Override
    public void sendPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData) {
        try {
            byte[] data = this.encoder.encode(isCompressed, false, isCRC, this.server.getAppId(), messageId, serialNumber, bodyData, null);
            this.sendData(data);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

