/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.udp.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.seg.lib.net.server.udp.UDPServer;
import org.seg.lib.net.server.udp.handler.BaseUDPServerHandler;
import org.seg.lib.net.server.udp.handler.UDPServerHandler;
import org.seg.lib.net.server.udp.netty.SimpleNettyUDPHandler;

public class NettyUDPServer
implements UDPServer {
    private int appId = 104;
    private int receiveBufferSize = 4096;
    private UDPServerHandler handler = new BaseUDPServerHandler();
    private int port;
    private SimpleNettyUDPHandler nettyHandler = new SimpleNettyUDPHandler(this);
    private Channel serverChannel;

    public NettyUDPServer(int port) {
        this.port = port;
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public int getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(int appId) {
        this.appId = appId;
    }

    @Override
    public void setHandler(UDPServerHandler handler) {
        this.handler = handler;
    }

    @Override
    public UDPServerHandler getHandler() {
        return this.handler;
    }

    @Override
    public void send(byte[] data, int offset, int length, SocketAddress address) {
        ChannelBuffer buff = ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length);
        this.serverChannel.write((Object)buff, address);
    }

    @Override
    public void send(byte[] data, SocketAddress address) {
        this.send(data, 0, data.length, address);
    }

    @Override
    public void startService() {
        NioDatagramChannelFactory channelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap((ChannelFactory)channelFactory);
        bootstrap.setOption("receiveBufferSize", (Object)this.receiveBufferSize);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{NettyUDPServer.this.nettyHandler});
            }
        });
        this.serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        System.out.println("netty udp server ready![" + this.port + "]");
    }
}

