/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.udp.oio;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import org.seg.lib.net.encoder.SegPackageEncoder;
import org.seg.lib.net.server.udp.SocketSession;
import org.seg.lib.net.server.udp.UDPServer;

public class OIOSession
implements SocketSession {
    private UDPServer server;
    private DatagramSocket socket;
    private SocketAddress remoteAddress;
    private SegPackageEncoder encoder = new SegPackageEncoder();

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public OIOSession(UDPServer server, DatagramSocket socket, SocketAddress remoteAddress) {
        this.server = server;
        this.socket = socket;
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void sendData(byte[] data) {
        try {
            DatagramPacket p = new DatagramPacket(data, 0, data.length, this.remoteAddress);
            this.socket.send(p);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void sendPackage(boolean isCompressed, boolean isEncrypt, boolean isCRC, short messageId, int serialNumber, byte[] bodyData) {
        try {
            byte[] data = this.encoder.encode(isCompressed, false, isCRC, this.server.getAppId(), messageId, serialNumber, bodyData, null);
            this.sendData(data);
        }
        catch (Throwable e) {
            this.server.getHandler().exceptionCaught(e);
        }
    }
}

