/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.net.server.udp.oio;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.seg.lib.net.server.udp.UDPServer;
import org.seg.lib.net.server.udp.handler.BaseUDPServerHandler;
import org.seg.lib.net.server.udp.handler.UDPServerHandler;
import org.seg.lib.net.server.udp.oio.SegArrayBlockingQueue;
import org.seg.lib.net.server.udp.oio.Worker;

public class OIOUDPServer
implements UDPServer {
    private OIOUDPServer server = this;
    private int receiveBufferSize = 4096;
    private int appId = 103;
    private UDPServerHandler handler = new BaseUDPServerHandler();
    private int corePoolSize;
    private int port;
    private int maximumPoolSize = this.corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private int blockQueueSize = this.corePoolSize;
    private DatagramSocket socket;

    public OIOUDPServer(int port) {
        this.port = port;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getBlockQueueSize() {
        return this.blockQueueSize;
    }

    public void setBlockQueueSize(int blockQueueSize) {
        this.blockQueueSize = blockQueueSize;
    }

    @Override
    public void setReceiveBufferSize(int buffSize) {
        this.receiveBufferSize = buffSize;
    }

    @Override
    public int getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(int appId) {
        this.appId = appId;
    }

    @Override
    public void setHandler(UDPServerHandler handler) {
        this.handler = handler;
    }

    @Override
    public UDPServerHandler getHandler() {
        return this.handler;
    }

    @Override
    public void startService() {
        Thread thread = new Thread(new ServiceThread());
        thread.start();
    }

    @Override
    public void send(byte[] data, int offset, int length, SocketAddress remoteAddress) {
        try {
            DatagramPacket p = new DatagramPacket(data, offset, length, remoteAddress);
            this.socket.send(p);
        }
        catch (Throwable e) {
            this.getHandler().exceptionCaught(e);
        }
    }

    @Override
    public void send(byte[] data, SocketAddress address) {
        this.send(data, 0, data.length, address);
    }

    private class ServiceThread
    implements Runnable {
        private boolean runFlag = true;

        private ServiceThread() {
        }

        @Override
        public void run() {
            try {
                OIOUDPServer.this.socket = new DatagramSocket(OIOUDPServer.this.port);
            }
            catch (SocketException e) {
                e.printStackTrace();
                return;
            }
            SegArrayBlockingQueue<Runnable> queue = new SegArrayBlockingQueue<Runnable>(OIOUDPServer.this.blockQueueSize);
            ThreadPoolExecutor exe = new ThreadPoolExecutor(OIOUDPServer.this.corePoolSize, OIOUDPServer.this.maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, queue);
            System.out.println("udp Server ready![" + OIOUDPServer.this.port + "]");
            while (this.runFlag) {
                try {
                    byte[] data = new byte[OIOUDPServer.this.receiveBufferSize];
                    DatagramPacket p = new DatagramPacket(data, 0, data.length);
                    OIOUDPServer.this.socket.receive(p);
                    Worker worker = new Worker(p, OIOUDPServer.this.socket, OIOUDPServer.this.server);
                    exe.execute(worker);
                }
                catch (Throwable e) {
                    OIOUDPServer.this.getHandler().exceptionCaught(e);
                }
            }
        }
    }
}

