/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.seg.lib.stream.PackageHandler;
import org.seg.lib.stream.StreamAnalysor;
import org.seg.lib.util.Util;

public class BaseStreamAnalysor
implements StreamAnalysor {
    private PackageHandler handler;
    private static final int HEAD_SIZE = 16;
    private List<byte[]> headByteList = new ArrayList<byte[]>();
    private List<byte[]> bodyByteList = new ArrayList<byte[]>();
    private int headNeed = 16;
    private int bodyNeed = 0;
    private int tempTotalSize;

    public BaseStreamAnalysor(PackageHandler handler) {
        this.handler = handler;
    }

    private void reset() {
        this.headByteList.clear();
        this.bodyByteList.clear();
        this.headNeed = 16;
        this.bodyNeed = 0;
    }

    private int calTotalSize() {
        int totalSize;
        ByteBuffer buff = ByteBuffer.allocate(16);
        for (byte[] b : this.headByteList) {
            buff.put(b);
        }
        this.tempTotalSize = totalSize = Util.getInt(buff.array(), 12);
        return totalSize;
    }

    private void dealPackage() throws Exception {
        try {
            ByteBuffer buff = ByteBuffer.allocate(this.tempTotalSize);
            for (byte[] b : this.headByteList) {
                buff.put(b);
            }
            for (byte[] b : this.bodyByteList) {
                buff.put(b);
            }
            this.handler.packageReceived(buff.array());
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void handleStream(ByteBuffer buff, int len) throws Exception {
        int leftBytes;
        while ((leftBytes = buff.limit() - buff.position()) > 0) {
            byte[] temp;
            if (this.headNeed == 0 && this.bodyNeed == 0) {
                this.reset();
                throw new IOException("###error:0 0  left:" + leftBytes);
            }
            if (this.headNeed > 0) {
                if (leftBytes < this.headNeed) {
                    temp = new byte[leftBytes];
                    buff.get(temp);
                    if (this.headNeed == 16 && temp[0] != -2) {
                        throw new IOException("stx is wrong:" + temp[0]);
                    }
                    this.headByteList.add(temp);
                    this.headNeed -= leftBytes;
                    break;
                }
                temp = new byte[this.headNeed];
                buff.get(temp);
                if (this.headNeed == 16 && temp[0] != -2) {
                    throw new IOException("stx is wrong:" + temp[0]);
                }
                this.headByteList.add(temp);
                this.headNeed = 0;
                int totalSize = this.calTotalSize();
                if (totalSize < 16 || totalSize > 0x1000000) {
                    this.reset();
                    throw new IOException("###large package, length:" + totalSize);
                }
                this.bodyNeed = totalSize - 16;
                if (this.bodyNeed == 0) {
                    this.dealPackage();
                }
            }
            if ((leftBytes = buff.limit() - buff.position()) == 0 || this.bodyNeed <= 0) continue;
            if (leftBytes < this.bodyNeed) {
                temp = new byte[leftBytes];
                buff.get(temp);
                this.bodyByteList.add(temp);
                this.bodyNeed -= leftBytes;
                break;
            }
            temp = new byte[this.bodyNeed];
            buff.get(temp);
            this.bodyByteList.add(temp);
            this.bodyNeed = 0;
            this.dealPackage();
        }
    }
}

