/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test;

import com.google.protobuf.ByteString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.handler.BaseClientHandler;
import org.seg.lib.net.client.tcp.TCPClientImpl;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.test.TestClientThread;
import org.seg.lib.test.TestCommunicateThread;
import org.seg.lib.test.TestServerThread;

public class AsynchronousClientTest {
    private static Object obj = new Object();
    private static TCPClientImpl clientImpl;

    public static void main(String[] args) {
        AsynchronousClientTest.testServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testClient() {
        TestClientThread thread = new TestClientThread();
        thread.start();
        Runtime runtime = Runtime.getRuntime();
        long m = runtime.maxMemory() / 1024L / 1024L;
        System.out.println("wait1...:" + m);
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.println("=========here=======");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testServer() {
        int threadCount = 100;
        int sendCount = 50000;
        TaskTracker tracker = new TaskTracker(threadCount);
        tracker.start();
        ArrayList<TestServerThread> list = new ArrayList<TestServerThread>();
        int i = 0;
        while (i < threadCount) {
            TestServerThread testThread = new TestServerThread("Thread" + i, sendCount, tracker);
            list.add(testThread);
            ++i;
        }
        System.out.println("all login");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        i = 0;
        while (i < list.size()) {
            ((TestServerThread)list.get(i)).start();
            ++i;
        }
        Runtime runtime = Runtime.getRuntime();
        long m = runtime.maxMemory() / 1024L / 1024L;
        System.out.println("wait0...:" + m);
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.println("=========here=======");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCommunicate() {
        int threadCount = 100;
        int sendCount = 50000;
        ArrayList<TestCommunicateThread> list = new ArrayList<TestCommunicateThread>();
        int i = 0;
        while (i < threadCount) {
            TestCommunicateThread testThread = new TestCommunicateThread("Thread" + i, sendCount);
            list.add(testThread);
            ++i;
        }
        System.out.println("all login");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        i = 0;
        while (i < list.size()) {
            ((TestCommunicateThread)list.get(i)).start();
            ++i;
        }
        Runtime runtime = Runtime.getRuntime();
        long m = runtime.maxMemory() / 1024L / 1024L;
        System.out.println("wait0...:" + m);
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.println("=========here=======");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simpleTest() {
        String ip = "127.0.0.1";
        int port = 9001;
        clientImpl = new TCPClientImpl(ip, port);
        clientImpl.setHandler(new SimpleTestHandler());
        LoginBuff.Login.Builder loginBuilder = LoginBuff.Login.newBuilder();
        loginBuilder.setUsername("admin");
        loginBuilder.setPassword("pwd");
        boolean encryption = true;
        if (encryption) {
            try {
                clientImpl.initRSA();
                loginBuilder.setRsaModule(ByteString.copyFrom((byte[])clientImpl.getRSAModuleBytes()));
                loginBuilder.setRsaKey(ByteString.copyFrom((byte[])clientImpl.getRSAPublicExponentBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LoginBuff.Login login = loginBuilder.build();
        try {
            clientImpl.login(login);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            Object e = obj;
            synchronized (e) {
                obj.wait();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private static class SimpleTestHandler
    extends BaseClientHandler {
        private SimpleTestHandler() {
        }

        @Override
        protected void handleLoginAck(Client client, SegPackage pkg) throws Exception {
            super.handleLoginAck(client, pkg);
            LoginAckBuff.LoginAck loginAck = LoginAckBuff.LoginAck.parseFrom(pkg.getRealBody());
            if (loginAck.getResult() == 0) {
                short cmdId = 123;
                clientImpl.sendPackage(cmdId, "Hello World!".getBytes());
            }
        }

        @Override
        protected void handleOthers(Client client, SegPackage pkg) {
        }
    }

    public static class TaskTracker {
        private int taskCount;
        private int endCount = 0;
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private Date startTime = new Date();

        public TaskTracker(int taskCount) {
            this.taskCount = taskCount;
        }

        public void start() {
            this.startTime = new Date();
            System.out.println("start at:" + this.sdf.format(this.startTime));
        }

        public synchronized void endone() {
            ++this.endCount;
            if (this.endCount == this.taskCount) {
                Date endTime = new Date();
                long times = endTime.getTime() - this.startTime.getTime();
                System.out.println("end at:" + this.sdf.format(endTime) + ", time:" + times + " ms");
            }
        }
    }
}

