/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test;

import com.google.protobuf.ByteString;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.handler.BaseClientHandler;
import org.seg.lib.net.client.tcp.TCPClientImpl;
import org.seg.lib.net.data.SegPackage;

public class TestClientThread
extends Thread {
    private TCPClientImpl clientImpl = new TCPClientImpl(this.ip, this.port);
    private String ip = "90.0.12.149";
    private int port = 9527;
    private static int count = 0;

    public TestClientThread() {
        this.clientImpl.setHandler(new TestClientThreadHandler());
        if (this.clientImpl.connect()) {
            System.out.println("TestClientThread connnect ok");
        }
    }

    @Override
    public void run() {
        LoginBuff.Login.Builder loginBuilder = LoginBuff.Login.newBuilder();
        loginBuilder.setUsername("admin");
        loginBuilder.setPassword("pwd");
        boolean encryption = true;
        if (encryption) {
            try {
                this.clientImpl.initRSA();
                loginBuilder.setRsaModule(ByteString.copyFrom((byte[])this.clientImpl.getRSAModuleBytes()));
                loginBuilder.setRsaKey(ByteString.copyFrom((byte[])this.clientImpl.getRSAPublicExponentBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LoginBuff.Login login = loginBuilder.build();
        try {
            this.clientImpl.login(login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TestClientThreadHandler
    extends BaseClientHandler {
        private long starttime = 0L;
        private long endtime = 0L;

        private TestClientThreadHandler() {
        }

        @Override
        protected void handleLoginAck(Client client, SegPackage pkg) throws Exception {
            super.handleLoginAck(client, pkg);
            LoginAckBuff.LoginAck loginAck = LoginAckBuff.LoginAck.parseFrom(pkg.getRealBody());
            if (loginAck.getResult() == 0) {
                short cmdId = 123;
                TestClientThread.this.clientImpl.sendPackage(cmdId, "download".getBytes(), false, false, false);
                this.starttime = System.currentTimeMillis();
                System.out.println("start here..");
            }
        }

        @Override
        protected void handleOthers(Client client, SegPackage pkg) {
            if (pkg.getHead().getMessageId() == 1233) {
                byte[] data = pkg.getRealBody();
                String info = new String(data);
                if ("send data".equals(info)) {
                    count = count + 1;
                    if (count % 50000 == 0) {
                        System.out.println("received:" + count);
                    }
                } else if ("send over".equals(info)) {
                    this.endtime = System.currentTimeMillis();
                    long time = this.endtime - this.starttime;
                    String speed = time == 0L ? "" : String.valueOf(1.0 * (double)count / (double)time * 1000.0);
                    System.out.println("client receive count:" + count + ", time:" + time + ", speed:" + speed);
                } else {
                    System.out.println("info:" + info);
                }
            }
        }
    }
}

