/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;

public class TestNServer {
    public static void main(String[] args) {
        NioDatagramChannelFactory channelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool(), 8);
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap((ChannelFactory)channelFactory);
        bootstrap.setOption("receiveBufferSize", (Object)10);
        final AHandler handler = new AHandler();
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{handler});
            }
        });
        int port = 9527;
        bootstrap.bind((SocketAddress)new InetSocketAddress(port));
        System.out.println("netty server ready![" + port + "]");
    }

    private static class AHandler
    extends SimpleChannelUpstreamHandler {
        private int sleeped = 0;

        private AHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buff = (ChannelBuffer)e.getMessage();
            int len = buff.readableBytes();
            byte[] bs = new byte[len];
            buff.readBytes(bs);
            ++this.sleeped;
            --this.sleeped;
            System.out.println("sleeped-b:" + this.sleeped);
            String info = new String(bs);
            System.out.println("read:" + info);
            ChannelBuffer send = ChannelBuffers.wrappedBuffer((byte[])("server send " + info).getBytes());
            e.getChannel().write((Object)send, e.getRemoteAddress());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            e.getCause().printStackTrace();
            e.getChannel().close();
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            System.out.println("channelConnected");
            super.channelConnected(ctx, e);
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            System.out.println("channelDisconnected");
            super.channelDisconnected(ctx, e);
        }
    }
}

