/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test.client.tcp;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.handler.BaseClientHandler;
import org.seg.lib.net.data.Head;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.test.buff.DemoBuff;
import org.seg.lib.util.Util;

public class TCPHandler
extends BaseClientHandler {
    @Override
    public void handleLoginAck(Client client, SegPackage pkg) throws Exception {
        super.handleLoginAck(client, pkg);
        LoginAckBuff.LoginAck loginAck = LoginAckBuff.LoginAck.parseFrom(pkg.getRealBody());
        if (loginAck.getResult() == 0) {
            System.out.println("login ok");
            DemoBuff.Person.Builder builder = DemoBuff.Person.newBuilder();
            builder.setName("java");
            builder.setId(123);
            builder.setEmail("abcd@xx.yy");
            builder.addPhone(DemoBuff.Person.PhoneNumber.newBuilder().setNumber("13912345001").setType(DemoBuff.Person.PhoneType.MOBILE));
            builder.addPhone(DemoBuff.Person.PhoneNumber.newBuilder().setNumber("07551234567").setType(DemoBuff.Person.PhoneType.HOME));
            byte[] data = builder.build().toByteArray();
            client.sendPackage((short)10123, data);
        } else {
            System.out.println("login fail:" + loginAck.getResult());
        }
    }

    @Override
    protected void handleOthers(Client client, SegPackage pkg) throws Exception {
        Head head = pkg.getHead();
        if (head.getMessageId() == 10124) {
            DemoBuff.Person person = DemoBuff.Person.parseFrom(pkg.getRealBody());
            System.out.println("name:" + person.getName());
            System.out.println("id:" + person.getId());
            System.out.println("email:" + person.getEmail());
            List<DemoBuff.Person.PhoneNumber> list = person.getPhoneList();
            System.out.println("phones:" + list.size());
            int i = 0;
            while (i < list.size()) {
                DemoBuff.Person.PhoneNumber phone = list.get(i);
                System.out.println("phones[" + i + "]" + phone.getNumber() + "(" + (Object)((Object)phone.getType()) + ")");
                ++i;
            }
            System.out.println();
        } else {
            short messageId = head.getMessageId();
            System.out.println("receive package:" + messageId + ", e:" + (messageId == -32765));
            if (messageId == 34) {
                byte[] rbody = pkg.getRealBody();
                System.out.println("realBody:" + Util.getBytesString(rbody));
                int sn = Util.getInt(rbody);
                String call = new String(rbody, 4, 11);
                short code = Util.getShort(rbody, 24);
                byte[] bcd = new byte[7];
                System.arraycopy(rbody, 26, bcd, 0, 7);
                String time = Util.bcd2str(bcd);
                short len = Util.getShort(rbody, 33);
                String content = null;
                if (len != rbody.length - 35) {
                    System.err.println("len:" + len + ", len1:" + (rbody.length - 35));
                } else {
                    try {
                        content = new String(rbody, 35, (int)len, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("sn:" + sn + ", call:" + call + ", code:" + code + ", time:" + time + ", time1:" + Util.getBytesString(rbody, 26, 7) + ", content:" + content + ", isEncryption:" + pkg.getHead().isEncryption() + ", isCom:" + pkg.getHead().isCompressed());
            }
        }
    }

    @Override
    public void exceptionCaught(Throwable e) {
        e.printStackTrace();
    }
}

