/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test.client.udp;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seg.lib.buff.LoginAckBuff;
import org.seg.lib.net.client.Client;
import org.seg.lib.net.client.handler.BaseClientHandler;
import org.seg.lib.net.data.SegPackage;

public class UDPClientHandler
extends BaseClientHandler {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int backCount = 0;

    @Override
    protected void handleOthers(Client client, SegPackage pkg) {
        if (pkg.getHead().getMessageId() == 123) {
            ++this.backCount;
        } else if (pkg.getHead().getMessageId() == 321) {
            System.out.println("backCount:" + this.backCount);
        } else {
            System.out.println("messageId:" + pkg.getHead().getMessageId() + "[" + this.sdf.format(new Date()) + "]");
        }
    }

    @Override
    protected void handleLoginAck(Client client, SegPackage pkg) throws Exception {
        super.handleLoginAck(client, pkg);
        LoginAckBuff.LoginAck loginack = LoginAckBuff.LoginAck.parseFrom(pkg.getRealBody());
        System.out.println("client receive login ack:" + loginack.getResult());
        if (loginack.getResult() == 0) {
            Thread thread = new Thread(new SendThread(client));
            thread.start();
        }
    }

    private class SendThread
    implements Runnable {
        private Client client;

        public SendThread(Client client) {
            this.client = client;
        }

        @Override
        public void run() {
            byte[] body = new byte[]{};
            short cmdId1 = 8;
            short cmdId2 = 9;
            int count = 100000;
            int i = 0;
            while (i < count) {
                this.client.sendPackage(cmdId1, body);
                if (++i % 450 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.client.sendPackage(cmdId2, body);
        }
    }
}

