/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test.server.netty.udp;

import java.net.InetSocketAddress;
import java.util.List;
import org.seg.lib.net.data.Head;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.server.udp.SocketSession;
import org.seg.lib.net.server.udp.UDPServer;
import org.seg.lib.net.server.udp.handler.BaseUDPServerHandler;
import org.seg.lib.test.buff.DemoBuff;
import org.seg.lib.util.SegPackageUtil;

public class UDPHandler
extends BaseUDPServerHandler {
    private long first = 0L;
    private long last = 0L;
    private int count = 0;

    @Override
    protected void handleOthers(SegPackage pkg, UDPServer server, SocketSession session) throws Exception {
        Head head = pkg.getHead();
        if (head.getMessageId() == 7) {
            InetSocketAddress address = new InetSocketAddress("90.0.255.255", 7788);
            server.send("abc_123".getBytes(), address);
        } else if (head.getMessageId() == 8) {
            if (this.first == 0L) {
                this.first = System.currentTimeMillis();
            }
            this.last = System.currentTimeMillis();
            ++this.count;
            session.sendPackage(false, false, false, (short)123, 100, session.getRemoteAddress().toString().getBytes());
        } else if (head.getMessageId() == 9) {
            System.out.println("count:" + this.count + ", time: " + (this.last - this.first));
            session.sendPackage(false, false, false, (short)321, 100, session.getRemoteAddress().toString().getBytes());
            this.first = 0L;
            this.last = 0L;
            this.count = 0;
        } else if (head.getMessageId() == 10123) {
            byte[] realBody = pkg.getRealBody();
            DemoBuff.Person person = DemoBuff.Person.parseFrom(realBody);
            String name = person.getName();
            int id = person.getId();
            String email = person.getEmail();
            List<DemoBuff.Person.PhoneNumber> phones = person.getPhoneList();
            System.out.println("name:" + name);
            System.out.println("id:" + id);
            System.out.println("email:" + email);
            System.out.println("phones:" + phones.size());
            int i = 0;
            while (i < phones.size()) {
                DemoBuff.Person.PhoneNumber phone = phones.get(i);
                System.out.println("phones[" + i + "]:" + phone.getNumber() + "(" + phone.getType().toString() + ")");
                ++i;
            }
            System.out.println();
            session.sendPackage(false, false, false, (short)10124, SegPackageUtil.getSerialNumber(), realBody);
        }
    }

    public void showMessage(SegPackage pkg) {
        Head head = pkg.getHead();
        StringBuilder builder = new StringBuilder();
        builder.append("UDP message, messageId:").append(head.getMessageId()).append("\n");
        builder.append("isEncryption:").append(head.isEncryption()).append("\n");
        builder.append("isCompressed:").append(head.isCompressed()).append("\n");
        builder.append("isCRC:").append(head.isCRC()).append("\n");
        builder.append("getMessageId:").append(head.getMessageId()).append("\n");
        builder.append("getAppId:").append(head.getAppId()).append("\n");
        builder.append("getSequenceNo:").append(head.getSequenceNo()).append("\n");
        builder.append("getLength:").append(head.getLength()).append("\n");
        System.out.println(builder);
    }

    @Override
    public void exceptionCaught(Throwable e) {
        e.printStackTrace();
    }
}

