/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.test.server.tcp;

import java.io.UnsupportedEncodingException;
import org.seg.lib.buff.LoginBuff;
import org.seg.lib.net.data.Head;
import org.seg.lib.net.data.SegPackage;
import org.seg.lib.net.server.tcp.SocketSession;
import org.seg.lib.net.server.tcp.TCPServer;
import org.seg.lib.net.server.tcp.handler.BaseTCPServerHandler;
import org.seg.lib.util.SegPackageUtil;
import org.seg.lib.util.Util;

public class DemoHandler
extends BaseTCPServerHandler {
    private int[] counts = new int[8];
    private int endCount = 0;

    @Override
    protected int checkLogin(LoginBuff.Login login) {
        String userName = login.getUsername();
        String password = login.getPassword();
        if (!"admin".equals(userName)) {
            return 2;
        }
        if (!"pwd".equals(password)) {
            return 3;
        }
        return 0;
    }

    private int getNumber(boolean isCompressed, boolean isEncryption, boolean isCRC) {
        int num = 0;
        if (isCompressed) {
            num += 4;
        }
        if (isEncryption) {
            num += 2;
        }
        if (isCRC) {
            ++num;
        }
        return num;
    }

    @Override
    protected void handleOthers(SegPackage pkg, TCPServer server, SocketSession session) {
        Head head = pkg.getHead();
        byte[] realBody = pkg.getRealBody();
        if (head.getMessageId() == 123) {
            byte[] data = pkg.getRealBody();
            String info = new String(data);
            if ("download".equals(info)) {
                int count = 200000;
                int i = 0;
                while (i < count) {
                    session.sendPackage(false, false, false, (short)1233, SegPackageUtil.getSerialNumber(), "send data".getBytes());
                    ++i;
                }
                session.sendPackage(false, false, false, (short)1233, SegPackageUtil.getSerialNumber(), "send over".getBytes());
            } else {
                System.out.println("cmd 123, info:" + info);
            }
        } else if (head.getMessageId() == 1234) {
            byte[] bs = pkg.getRealBody();
            System.out.println("receive:" + new String(bs) + "[en:" + head.isEncryption() + ", comp:" + head.isCompressed() + ", crc:" + head.isCRC() + "]");
        } else if (head.getMessageId() == 10010) {
            String info = new String(realBody);
            if ("hello".equals(info)) {
                boolean isCompressed = head.isCompressed();
                boolean isEncryption = head.isEncryption();
                boolean isCRC = head.isCRC();
                int n = this.getNumber(isCompressed, isEncryption, isCRC);
                this.counts[n] = this.counts[n] + 1;
            } else {
                System.out.println("received:" + info);
            }
        } else if (head.getMessageId() == 10011) {
            ++this.endCount;
            if (this.endCount == 100) {
                int i = 0;
                while (i < this.counts.length) {
                    System.out.println("counts[" + i + "]:" + this.counts[i]);
                    ++i;
                }
            }
        } else if (head.getMessageId() == 10012) {
            byte[] body = pkg.getRealBody();
            System.out.println("--------10012---------:" + body);
            byte v1 = body[0];
            short v2 = Util.getShort(body, 1);
            int v3 = Util.getInt(body, 3);
            long v4 = Util.getLong(body, 7);
            System.out.println("v1:" + v1);
            System.out.println("v2:" + v2);
            System.out.println("v3:" + v3);
            System.out.println("v4:" + v4);
            String v5 = null;
            try {
                v5 = new String(body, 15, v3, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("v5:" + v5);
        } else if (head.getMessageId() == 10123) {
            server.broadcastPackageToLogged(false, false, false, (short)10124, SegPackageUtil.getSerialNumber(), realBody, null);
        }
    }

    @Override
    public void clientConnected(TCPServer server, SocketSession session) {
        System.out.println("connected[" + server.getConnectionCount() + "]");
    }

    @Override
    public void clientDisconnected(TCPServer server, SocketSession session) {
        System.out.println("disconnected[" + server.getConnectionCount() + "]");
        server.broadcastPackageToLogged(false, false, false, (short)12321, SegPackageUtil.getSerialNumber(), "logout".getBytes(), session);
    }

    @Override
    public void exceptionCaught(Throwable e) {
        System.out.println("eee");
    }
}

