/*
 * Decompiled with CFR 0.152.
 */
package org.seg.lib.util;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;

public class Util {
    private static Deflater compresser = new Deflater();
    private static Inflater decompresser = new Inflater();
    public static long[] CRCList = Util.make_crc_table();

    public static byte[] ZlibCompress(byte[] input) {
        return Util.ZlibCompress(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ZlibCompress(byte[] input, int start, int length) {
        Deflater deflater = compresser;
        synchronized (deflater) {
            compresser.setInput(input, start, length);
            compresser.finish();
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            byte[] buff = new byte[1024];
            while (!compresser.finished()) {
                int len = compresser.deflate(buff);
                os.write(buff, 0, len);
            }
            compresser.reset();
            return os.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ZlibDecompress(byte[] input, int start, int length) throws DataFormatException {
        Inflater inflater = decompresser;
        synchronized (inflater) {
            decompresser.setInput(input, start, length);
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            byte[] buff = new byte[1024];
            while (!decompresser.finished()) {
                int len = decompresser.inflate(buff);
                os.write(buff, 0, len);
            }
            decompresser.reset();
            return os.toByteArray();
        }
    }

    public static byte[] ZlibDecompress(byte[] input) throws DataFormatException {
        return Util.ZlibDecompress(input, 0, input.length);
    }

    public static long CRC32(byte[] bs, int start, int length) {
        CRC32 crc32 = new CRC32();
        crc32.update(bs, start, length);
        return crc32.getValue();
    }

    public static long CRC32(byte[] bs) {
        return Util.CRC32(bs, 0, bs.length);
    }

    private static long[] make_crc_table() {
        long[] crc_table = new long[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
            ++n;
        }
        return crc_table;
    }

    public static long CRC32C(byte[] buf, int start, int length) {
        long dwCRC32 = 0L;
        int i = start;
        while (i < start + length) {
            dwCRC32 = dwCRC32 << 8 ^ CRCList[(int)((dwCRC32 >> 24 ^ (long)buf[i]) & 0xFFL)];
            ++i;
        }
        return dwCRC32 & 0xFFFFFFFFL;
    }

    public static long CRC32C(byte[] buf) {
        return Util.CRC32C(buf, 0, buf.length);
    }

    public static final String MD5(byte[] b) {
        return Util.MD5(b, 0, b.length);
    }

    public static final String MD5(byte[] b, int offset, int len) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(b, offset, len);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            int i = 0;
            while (i < j) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final String MD5(String s) {
        return Util.MD5(s.getBytes());
    }

    public static byte[] MD5C(byte[] b, int offset, int len) {
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(b, offset, len);
            return mdInst.digest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] MD5C(byte[] b) {
        return Util.MD5C(b, 0, b.length);
    }

    public static byte[] getShortByte(short v) {
        byte[] bs = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return bs;
    }

    public static byte[] getIntByte(int v) {
        byte[] bs = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return bs;
    }

    public static byte[] getLongByte(long v) {
        byte[] bs = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bs;
    }

    public static int getInt(byte[] buff) {
        return Util.getInt(buff, 0);
    }

    public static int getInt(byte[] buff, int start) {
        int a1 = buff[start] & 0xFF;
        int a2 = buff[start + 1] & 0xFF;
        int a3 = buff[start + 2] & 0xFF;
        int a4 = buff[start + 3] & 0xFF;
        return (a1 << 24) + (a2 << 16) + (a3 << 8) + (a4 << 0);
    }

    public static long getLong(byte[] buff) {
        return Util.getLong(buff, 0);
    }

    public static long getLong(byte[] buff, int start) {
        long a1 = buff[start] & 0xFF;
        long a2 = buff[start + 1] & 0xFF;
        long a3 = buff[start + 2] & 0xFF;
        long a4 = buff[start + 3] & 0xFF;
        long a5 = buff[start + 4] & 0xFF;
        long a6 = buff[start + 5] & 0xFF;
        long a7 = buff[start + 6] & 0xFF;
        long a8 = buff[start + 7] & 0xFF;
        return (a1 << 56) + (a2 << 48) + (a3 << 40) + (a4 << 32) + (a5 << 24) + (a6 << 16) + (a7 << 8) + (a8 << 0);
    }

    public static short getShort(byte[] buff) {
        return Util.getShort(buff, 0);
    }

    public static short getShort(byte[] buff, int start) {
        int a1 = buff[start] & 0xFF;
        int a2 = buff[start + 1] & 0xFF;
        return (short)((a1 << 8) + (a2 << 0));
    }

    public static byte[] str2bcd(String str) {
        if (str.length() % 2 != 0) {
            str = "0" + str;
        }
        byte[] buff = new byte[str.length() / 2];
        int step = 0;
        while (step < str.length() / 2) {
            byte b1 = Util.getBCDCharByte(str.charAt(2 * step));
            byte b2 = Util.getBCDCharByte(str.charAt(2 * step + 1));
            buff[step] = (byte)(b1 << 4 & 0xF0 | b2 & 0xF);
            ++step;
        }
        return buff;
    }

    private static byte getBCDCharByte(char x) {
        if (x >= '0' && x <= '9') {
            return (byte)(x - 48);
        }
        return (byte)(x - 97 + 10);
    }

    private static char getBCDChar(byte _lower_4bit) {
        if (_lower_4bit >= 0 && _lower_4bit <= 9) {
            return (char)(48 + _lower_4bit);
        }
        return (char)(97 + _lower_4bit - 10);
    }

    public static String bcd2str(byte[] bcd) {
        return Util.bcd2str(bcd, 0, bcd.length);
    }

    public static String bcd2str(byte[] bcd, int offset) {
        return Util.bcd2str(bcd, offset, bcd.length - offset);
    }

    public static String bcd2str(byte[] bcd, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        int i = offset;
        while (i < offset + length) {
            byte b1 = (byte)((bcd[i] & 0xF0) >>> 4);
            byte b0 = (byte)(bcd[i] & 0xF);
            sb.append(Util.getBCDChar(b1));
            sb.append(Util.getBCDChar(b0));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] encodeRSA(Key key, byte[] data) {
        return Util.encodeRSA(key, data, 0, data.length);
    }

    public static byte[] encodeRSA(Key key, byte[] data, int offset, int length) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, key);
            return cipher.doFinal(data, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeRSA(Key privateKey, byte[] encodeBytes) {
        return Util.decodeRSA(privateKey, encodeBytes, 0, encodeBytes.length);
    }

    public static byte[] decodeRSA(Key privateKey, byte[] encodeBytes, int offset, int length) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return cipher.doFinal(encodeBytes, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encodeDES(Key key, byte[] data) {
        return Util.encodeDES(key, data, 0, data.length);
    }

    public static byte[] encodeDES(Key key, byte[] data, int offset, int length) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            return cipher.doFinal(data, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encodeDESC(Key key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        cipher.init(1, key);
        int left = data.length % 8;
        if (left == 0) {
            return cipher.doFinal(data);
        }
        byte[] encodeData = new byte[data.length];
        byte[] encodeTop = cipher.doFinal(data, 0, data.length - left);
        System.arraycopy(encodeTop, 0, encodeData, 0, encodeTop.length);
        System.arraycopy(data, data.length - left, encodeData, encodeTop.length, left);
        return encodeData;
    }

    public static byte[] decodeDESC(Key key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        cipher.init(2, key);
        int left = data.length % 8;
        if (left == 0) {
            return cipher.doFinal(data);
        }
        byte[] decodeData = new byte[data.length];
        byte[] decodeTop = cipher.doFinal(data, 0, data.length - left);
        System.arraycopy(decodeTop, 0, decodeData, 0, decodeTop.length);
        System.arraycopy(data, data.length - left, decodeData, decodeTop.length, left);
        return decodeData;
    }

    public static byte[] decodeDES(Key key, byte[] data) throws Exception {
        return Util.decodeDES(key, data, 0, data.length);
    }

    public static byte[] decodeDES(Key key, byte[] data, int offset, int length) throws Exception {
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, key);
        return cipher.doFinal(data, offset, length);
    }

    public static String getBytesString(byte[] bs) {
        return Util.getBytesString(bs, 0, bs.length);
    }

    public static String getHexString(byte[] bs) {
        return Util.getHexString(bs, 0, bs.length, " ");
    }

    public static String getHexString(byte[] bs, String split) {
        return Util.getHexString(bs, 0, bs.length, split);
    }

    public static String getHexString(byte[] bs, int offset, int length, String split) {
        StringBuilder info = new StringBuilder();
        int i = offset;
        int count = 0;
        while (count < length) {
            byte b = bs[i];
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                info.append("0");
            }
            info.append(s);
            if (split != null && count != length - 1) {
                info.append(split);
            }
            ++i;
            ++count;
        }
        return info.toString();
    }

    public static String getBytesString(byte[] bs, int offset, int length) {
        StringBuilder info = new StringBuilder();
        int i = offset;
        int count = 0;
        while (count < length) {
            byte b = bs[i];
            String db = Integer.toBinaryString(b);
            if (db.length() > 8) {
                db = db.substring(db.length() - 8);
            }
            info.append(Util.get8str(db)).append(" ");
            ++i;
            ++count;
        }
        if (info.length() > 0) {
            info.deleteCharAt(info.length() - 1);
        }
        return info.toString();
    }

    public static int indexOfZero(byte[] bs) {
        int i = 0;
        while (i < bs.length) {
            if (bs[i] == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfUnZero(byte[] bs) {
        int i = 0;
        while (i < bs.length) {
            if (bs[i] != 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static byte[] clearForeZero(byte[] bs) {
        int uz = Util.indexOfUnZero(bs);
        if (uz == 0) {
            return bs;
        }
        if (uz == -1) {
            return new byte[0];
        }
        byte[] bscopy = new byte[bs.length - uz];
        System.arraycopy(bs, uz, bscopy, 0, bs.length - uz);
        return bscopy;
    }

    public static boolean equals(byte[] bs1, byte[] bs2) {
        if (bs1.length != bs2.length) {
            return false;
        }
        int i = 0;
        while (i < bs1.length) {
            if (bs1[i] != bs2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String get8str(String info) {
        int len = info.length();
        if (len < 8) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 8 - len) {
                sb.append("0");
                ++i;
            }
            info = String.valueOf(sb.toString()) + info;
        }
        return info;
    }
}

