/*
 * Decompiled with CFR 0.152.
 */
package com.edison;

import com.edison.Annotations;
import com.edison.EmptyCommentGenerator;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class CommentGenerator
extends EmptyCommentGenerator {
    private final Collection<Annotations> annotations;
    private String author;
    private String currentDateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());

    public CommentGenerator() {
        this.annotations = new LinkedHashSet<Annotations>(Annotations.values().length);
    }

    @Override
    public void addConfigurationProperties(Properties properties) {
        this.annotations.add(Annotations.DATA);
        for (String stringPropertyName : properties.stringPropertyNames()) {
            Annotations annotation;
            if (stringPropertyName.contains(".") || !Boolean.parseBoolean(properties.getProperty(stringPropertyName)) || (annotation = Annotations.getValueOf(stringPropertyName)) == null) continue;
            String optionsPrefix = stringPropertyName + ".";
            for (String propertyName : properties.stringPropertyNames()) {
                if (!propertyName.startsWith(optionsPrefix)) continue;
                String propertyValue = properties.getProperty(propertyName);
                annotation.appendOptions(propertyName, propertyValue);
                this.annotations.add(annotation);
                this.annotations.addAll(Annotations.getDependencies(annotation));
            }
            this.annotations.add(annotation);
        }
        this.author = properties.getProperty("author");
    }

    @Override
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String remarks = introspectedTable.getRemarks();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" * " + remarks);
        topLevelClass.addJavaDocLine(" * @author   " + this.author);
        topLevelClass.addJavaDocLine(" * @date   " + this.currentDateStr);
        topLevelClass.addJavaDocLine(" */");
        this.addClassAnnotation(topLevelClass);
    }

    private void addClassAnnotation(TopLevelClass topLevelClass) {
        for (Annotations annotation : this.annotations) {
            topLevelClass.addImportedType(annotation.javaType);
            topLevelClass.addAnnotation(annotation.asAnnotation());
        }
    }

    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remarks = introspectedColumn.getRemarks();
        field.addJavaDocLine("/**");
        field.addJavaDocLine(" * " + remarks);
        field.addJavaDocLine(" */");
    }
}

