/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.JSONPopulator;
import com.googlecode.jsonplugin.JSONUtil;
import com.googlecode.jsonplugin.annotations.SMDMethod;
import com.googlecode.jsonplugin.rpc.RPCError;
import com.googlecode.jsonplugin.rpc.RPCErrorCode;
import com.googlecode.jsonplugin.rpc.RPCResponse;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.ValueStack;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class JSONInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(JSONInterceptor.class);
    private boolean enableSMD = false;
    private boolean wrapWithComments;
    private String defaultEncoding = "ISO-8859-1";
    private boolean ignoreHierarchy = true;
    private String root;
    private List<Pattern> excludeProperties = null;
    private boolean ignoreSMDMethodInterfaces = true;

    public void destroy() {
    }

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String contentType = request.getHeader("content-type");
        Object rootObject = null;
        if (this.root != null) {
            ValueStack stack = invocation.getStack();
            rootObject = stack.findValue(this.root);
        } else {
            rootObject = invocation.getAction();
        }
        if (contentType != null && contentType.equalsIgnoreCase("application/json")) {
            Object obj = JSONUtil.deserialize(request.getReader());
            if (obj instanceof Map) {
                Map json = (Map)obj;
                JSONPopulator populator = new JSONPopulator();
                populator.populateObject(rootObject, json);
                return invocation.invoke();
            }
            log.error((Object)"Unable to deserialize JSON object from request");
            throw new JSONException("Unable to deserialize JSON object from request");
        }
        if (contentType != null && contentType.equalsIgnoreCase("application/json-rpc")) {
            RPCResponse result = null;
            if (!this.enableSMD) {
                String message = "Request with content type of 'application/json-rpc' was received but SMD is not enabled for this interceptor. Set 'enableSMD' to true to enable it";
                RPCResponse rpcResponse = new RPCResponse();
                this.buildError(rpcResponse, message, RPCErrorCode.SMD_DISABLED);
                result = rpcResponse;
                String json = JSONUtil.serialize(result, this.excludeProperties, this.ignoreHierarchy);
                JSONUtil.writeJSONToResponse(response, this.defaultEncoding, this.wrapWithComments, json, true);
                return "none";
            }
            Object obj = JSONUtil.deserialize(request.getReader());
            if (obj instanceof Map) {
                Map smd = (Map)obj;
                try {
                    result = this.invoke(rootObject, smd);
                }
                catch (Exception e) {
                    Throwable t = e;
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    RPCResponse rpcResponse = new RPCResponse();
                    this.buildError(rpcResponse, t.getMessage(), RPCErrorCode.EXCEPTION);
                    log.error((Object)"stack trace:", (Throwable)e);
                    rpcResponse.getError().setName(t.getClass().getName());
                    result = rpcResponse;
                }
            } else {
                String message = "SMD request was not in the right format. See http://json-rpc.org";
                RPCResponse rpcResponse = new RPCResponse();
                this.buildError(rpcResponse, message, RPCErrorCode.INVALID_PROCEDURE_CALL);
                result = rpcResponse;
            }
            String json = JSONUtil.serialize(result, this.excludeProperties, this.ignoreHierarchy);
            JSONUtil.writeJSONToResponse(response, this.defaultEncoding, this.wrapWithComments, json, true);
            return "none";
        }
        if (!log.isDebugEnabled()) return invocation.invoke();
        log.debug((Object)("Content type must be 'application/json' or 'application/json-rpc'. Ignoring request with content type " + contentType));
        return invocation.invoke();
    }

    public RPCResponse invoke(Object object, Map data) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, JSONException, InstantiationException, NoSuchMethodException, IntrospectionException {
        RPCResponse response = new RPCResponse();
        Object id = data.get("id");
        if (id == null) {
            String message = "'id' is required for JSON RPC";
            return this.buildError(response, message, RPCErrorCode.METHOD_NOT_FOUND);
        }
        response.setId(id.toString());
        Class<?> clazz = object.getClass();
        List parameters = (List)data.get("params");
        int parameterCount = parameters != null ? parameters.size() : 0;
        String methodName = (String)data.get("method");
        if (methodName == null) {
            String message = "'method' is required for JSON RPC";
            return this.buildError(response, message, RPCErrorCode.MISSING_METHOD);
        }
        Method method = this.getMethod(clazz, methodName, parameterCount);
        if (method == null) {
            String message = "Method " + methodName + " could not be found in action class.";
            return this.buildError(response, message, RPCErrorCode.METHOD_NOT_FOUND);
        }
        if (parameterCount > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<Object> invocationParameters = new ArrayList<Object>();
            if (parameterTypes.length != parameterCount) {
                String message = "Parameter count in request, " + parameterCount + " do not match expected parameter count for " + methodName + ", " + parameterTypes.length;
                return this.buildError(response, message, RPCErrorCode.PARAMETERS_MISMATCH);
            }
            JSONPopulator populator = new JSONPopulator();
            for (int i = 0; i < parameters.size(); ++i) {
                Object parameter = parameters.get(i);
                Class<?> paramType = parameterTypes[i];
                Object converted = populator.convert(paramType, parameter, method);
                invocationParameters.add(converted);
            }
            response.setResult(method.invoke(object, invocationParameters.toArray()));
        } else {
            response.setResult(method.invoke(object, new Object[0]));
        }
        return response;
    }

    private RPCResponse buildError(RPCResponse response, String message, RPCErrorCode code) {
        RPCError error = new RPCError();
        error.setCode(code.code());
        error.setMessage(message);
        log.error((Object)message);
        response.setError(error);
        return response;
    }

    private Method getMethod(Class clazz, String name, int parameterCount) {
        Method[] smdMethods;
        for (Method method : smdMethods = JSONUtil.listSMDMethods(clazz, this.ignoreSMDMethodInterfaces)) {
            if (!this.checkSMDMethodSignature(method, name, parameterCount)) continue;
            return method;
        }
        return null;
    }

    private boolean checkSMDMethodSignature(Method method, String name, int parameterCount) {
        SMDMethod smdMethodAnntotation = method.getAnnotation(SMDMethod.class);
        if (smdMethodAnntotation != null) {
            boolean paramsMatch;
            String alias = smdMethodAnntotation.name();
            boolean bl = paramsMatch = method.getParameterTypes().length == parameterCount;
            if (alias.length() == 0 && method.getName().equals(name) && paramsMatch || alias.equals(name) && paramsMatch) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnableSMD() {
        return this.enableSMD;
    }

    public void setEnableSMD(boolean enableSMD) {
        this.enableSMD = enableSMD;
    }

    public void setIgnoreSMDMethodInterfaces(boolean ignoreSMDMethodInterfaces) {
        this.ignoreSMDMethodInterfaces = ignoreSMDMethodInterfaces;
    }

    public void setWrapWithComments(boolean wrapWithComments) {
        this.wrapWithComments = wrapWithComments;
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setExcludeProperties(String commaDelim) {
        List<String> excludePatterns = JSONUtil.asList(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(Pattern.compile(pattern));
            }
        }
    }
}

