/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.annotations.JSON;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONPopulator {
    private static final Log log = LogFactory.getLog(JSONPopulator.class);
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";

    public JSONPopulator() {
    }

    public JSONPopulator(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void populateObject(Object object, Map elements) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IntrospectionException, IllegalArgumentException, JSONException, InstantiationException {
        Class<?> clazz = object.getClass();
        BeanInfo info = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Class<?>[] paramTypes;
            PropertyDescriptor prop = props[i];
            String name = prop.getName();
            if (!elements.containsKey(name)) continue;
            Object value = elements.get(name);
            Method method = prop.getWriteMethod();
            JSON json = prop.getWriteMethod().getAnnotation(JSON.class);
            if (json != null && !json.deserialize() || method == null || !Modifier.isPublic(method.getModifiers()) || (paramTypes = method.getParameterTypes()).length != 1) continue;
            Class<?> paramType = paramTypes[0];
            Object convertedValue = this.convert(paramType, value, method);
            method.invoke(object, convertedValue);
        }
    }

    public Object convert(Class clazz, Object value, Method method) throws IllegalArgumentException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        if (JSONPopulator.isJSONPrimitive(clazz)) {
            return this.convertPrimitive(clazz, value, method);
        }
        if (List.class.equals((Object)clazz) || Map.class.equals((Object)clazz)) {
            return value;
        }
        if (clazz.isArray()) {
            return this.convertToArray(value, method, value);
        }
        if (value instanceof Map) {
            Object convertedValue = clazz.newInstance();
            this.populateObject(convertedValue, (Map)value);
            return convertedValue;
        }
        throw new JSONException("Incompatible types for property " + method.getName());
    }

    private static boolean isJSONPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Date.class) || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class);
    }

    private Object convertToArray(Object target, Method accessor, Object value) throws JSONException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        Class<?> arrayType = accessor.getParameterTypes()[0].getComponentType();
        if (value instanceof List) {
            List values = (List)value;
            Object newArray = Array.newInstance(arrayType, values.size());
            for (int j = 0; j < values.size(); ++j) {
                Object listValue = values.get(j);
                if (arrayType.equals(Object.class)) {
                    Array.set(newArray, j, listValue);
                    continue;
                }
                if (JSONPopulator.isJSONPrimitive(arrayType)) {
                    Array.set(newArray, j, this.convertPrimitive(arrayType, listValue, accessor));
                    continue;
                }
                Object newObject = arrayType.newInstance();
                if (listValue instanceof Map) {
                    this.populateObject(newObject, (Map)listValue);
                    Array.set(newArray, j, newObject);
                    continue;
                }
                throw new JSONException("Incompatible types for property " + accessor.getName());
            }
            return newArray;
        }
        throw new JSONException("Incompatible types for property " + accessor.getName());
    }

    private Object convertPrimitive(Class clazz, Object value, Method method) throws JSONException {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (Short.TYPE.equals(clazz)) {
                return number.shortValue();
            }
            if (Short.class.equals((Object)clazz)) {
                return new Short(number.shortValue());
            }
            if (Byte.TYPE.equals(clazz)) {
                return number.byteValue();
            }
            if (Byte.class.equals((Object)clazz)) {
                return new Byte(number.byteValue());
            }
            if (Integer.TYPE.equals(clazz)) {
                return number.intValue();
            }
            if (Integer.class.equals((Object)clazz)) {
                return new Integer(number.intValue());
            }
            if (Long.TYPE.equals(clazz)) {
                return number.longValue();
            }
            if (Long.class.equals((Object)clazz)) {
                return new Long(number.longValue());
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.valueOf(number.floatValue());
            }
            if (Float.class.equals((Object)clazz)) {
                return new Float(number.floatValue());
            }
            if (Double.TYPE.equals(clazz)) {
                return number.doubleValue();
            }
            if (Double.class.equals((Object)clazz)) {
                return new Double(number.doubleValue());
            }
        } else {
            if (clazz.equals(Date.class)) {
                try {
                    JSON json = method.getAnnotation(JSON.class);
                    SimpleDateFormat formatter = json != null && json.format().length() > 0 ? new SimpleDateFormat(json.format()) : new SimpleDateFormat(this.dateFormat);
                    return formatter.parse((String)value);
                }
                catch (ParseException e) {
                    log.error((Object)e);
                    throw new JSONException("Unable to parse date from: " + value);
                }
            }
            if (value instanceof String) {
                String sValue = (String)value;
                if (Boolean.TYPE.equals(clazz)) {
                    return Boolean.valueOf(sValue);
                }
                if (Boolean.class.equals((Object)clazz)) {
                    return new Boolean(sValue);
                }
                if (Character.TYPE.equals(clazz) || Character.class.equals((Object)clazz)) {
                    char charValue = '\u0000';
                    if (sValue.length() > 0) {
                        charValue = sValue.charAt(0);
                    }
                    if (Character.TYPE.equals(clazz)) {
                        return Character.valueOf(charValue);
                    }
                    return new Character(charValue);
                }
            }
        }
        return value;
    }
}

