/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuffer buf = new StringBuffer();

    JSONReader() {
    }

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    public Object read(String string) throws JSONException {
        this.it = new StringCharacterIterator(string);
        this.c = this.it.first();
        return this.read();
    }

    private Object read() throws JSONException {
        Object ret = null;
        this.skipWhiteSpace();
        if (this.c == '\"') {
            this.next();
            ret = this.string('\"');
        } else if (this.c == '\'') {
            this.next();
            ret = this.string('\'');
        } else if (this.c == '[') {
            this.next();
            ret = this.array();
        } else if (this.c == ']') {
            ret = ARRAY_END;
            this.next();
        } else if (this.c == ',') {
            ret = COMMA;
            this.next();
        } else if (this.c == '{') {
            this.next();
            ret = this.object();
        } else if (this.c == '}') {
            ret = OBJECT_END;
            this.next();
        } else if (this.c == ':') {
            ret = COLON;
            this.next();
        } else if (this.c == 't' && this.next() == 'r' && this.next() == 'u' && this.next() == 'e') {
            ret = Boolean.TRUE;
            this.next();
        } else if (this.c == 'f' && this.next() == 'a' && this.next() == 'l' && this.next() == 's' && this.next() == 'e') {
            ret = Boolean.FALSE;
            this.next();
        } else if (this.c == 'n' && this.next() == 'u' && this.next() == 'l' && this.next() == 'l') {
            ret = null;
            this.next();
        } else if (Character.isDigit(this.c) || this.c == '-') {
            ret = this.number();
        } else {
            throw new JSONException("Input string is not well formed JSON (invalid char " + this.c + ")");
        }
        this.token = ret;
        return ret;
    }

    private Map object() throws JSONException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Object next = this.read();
        if (next != OBJECT_END) {
            String key = (String)next;
            while (this.token != OBJECT_END) {
                this.read();
                if (this.token == OBJECT_END) continue;
                ret.put(key, this.read());
                if (this.read() != COMMA) continue;
                Object name = this.read();
                if (name instanceof String) {
                    key = (String)name;
                    continue;
                }
                throw new JSONException("Input string is not well formed JSON (invalid char " + this.c + ")");
            }
        }
        return ret;
    }

    private List array() throws JSONException {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value);
            if (this.read() != COMMA) continue;
            value = this.read();
        }
        return ret;
    }

    private Object number() {
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        this.addDigits();
        if (this.c == '.') {
            this.add();
            this.addDigits();
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
        }
        return this.buf.indexOf(".") >= 0 ? (Number)Double.parseDouble(this.buf.toString()) : (Number)Long.parseLong(this.buf.toString());
    }

    private Object string(char quote) {
        this.buf.setLength(0);
        while (this.c != quote) {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(new Character(this.c));
                if (value == null) continue;
                this.add(value.charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private void addDigits() {
        while (Character.isDigit(this.c)) {
            this.add();
        }
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + this.c - 107;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + this.c - 75;
                }
            }
        }
        return (char)value;
    }

    static {
        escapes.put(new Character('\"'), new Character('\"'));
        escapes.put(new Character('\\'), new Character('\\'));
        escapes.put(new Character('/'), new Character('/'));
        escapes.put(new Character('b'), new Character('\b'));
        escapes.put(new Character('f'), new Character('\f'));
        escapes.put(new Character('n'), new Character('\n'));
        escapes.put(new Character('r'), new Character('\r'));
        escapes.put(new Character('t'), new Character('\t'));
    }
}

